/*
 * Decompiled with CFR 0.152.
 */
package com.avigoyal.imagepick.Utils;

import android.app.AlertDialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.avigoyal.imagepick.R;
import com.avigoyal.imagepick.Utils.OnDialogButtonClickListener;

public class DialogUtil {
    public static AlertDialog makeDialog(Context context, View view, boolean isCancelOnTouchOutside) {
        AlertDialog alertDialog = new AlertDialog.Builder(context).create();
        alertDialog.setCanceledOnTouchOutside(isCancelOnTouchOutside);
        alertDialog.setView(view);
        return alertDialog;
    }

    public static void showAlertDialog(Context context, String title, String description, String negativeButtonText, String positiveButtonText, boolean isCancelTouchOutside, final OnDialogButtonClickListener listener) {
        final AlertDialog alertDialog = new AlertDialog.Builder(context).create();
        alertDialog.setCanceledOnTouchOutside(isCancelTouchOutside);
        View customView = LayoutInflater.from((Context)context).inflate(R.layout.alert_dialog, null);
        TextView txvDialogTitle = (TextView)customView.findViewById(R.id.txv_alert_dialog_title);
        txvDialogTitle.setText((CharSequence)title);
        TextView dialogDesc = (TextView)customView.findViewById(R.id.txv_alert_dialog_description);
        dialogDesc.setText((CharSequence)description);
        Button btnCancel = (Button)customView.findViewById(R.id.btn_alert_dialog_cancel);
        if (negativeButtonText != null) {
            btnCancel.setText((CharSequence)negativeButtonText);
            btnCancel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    alertDialog.dismiss();
                    if (listener != null) {
                        listener.onDialogButtonClick(false);
                    }
                }
            });
        } else {
            btnCancel.setVisibility(8);
        }
        Button btnDone = (Button)customView.findViewById(R.id.btn_alert_dialog_done);
        if (positiveButtonText != null) {
            btnDone.setText((CharSequence)positiveButtonText);
            btnDone.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    alertDialog.dismiss();
                    if (listener != null) {
                        listener.onDialogButtonClick(true);
                    }
                }
            });
        } else {
            btnDone.setVisibility(8);
        }
        alertDialog.setView(customView);
        alertDialog.show();
    }
}

