/*
 * Decompiled with CFR 0.152.
 */
package com.avigoyal.imagepick;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.avigoyal.imagepick.GalleryGridAdapter;
import com.avigoyal.imagepick.OnRecyclerItemClickListener;
import com.avigoyal.imagepick.R;
import com.avigoyal.imagepick.Utils.DialogUtil;
import com.avigoyal.imagepick.model.GalleryImage;
import com.avigoyal.imagepick.ui.ActionBar;
import com.squareup.picasso.Picasso;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class ImagePickerActivity
extends Activity
implements ActionBar.ImagePickerActionBarClickListener,
OnRecyclerItemClickListener {
    public static final String ACTION_INTENT = "com.sixthcontinent.citizen.PICK_IMAGE";
    public static final String TAG_IMAGE_URI = "TAG_IMAGE_URI";
    public static final String ACTION_MODE = "action_mode";
    public static final String MAX_IMAGE = "max_image";
    private static final int PICK_FROM_CAMERA = 100100;
    public static final int PICK_SINGLE_IMAGE = 1;
    public static final int PICK_MULTIPLE_IMAGE = 10001;
    private int mMaxImage = -1;
    private RecyclerView mGalleryGridView;
    private GalleryGridAdapter mAdapter;
    private ArrayList<GalleryImage> mGalleyImageCol = new ArrayList();
    private Set<GalleryImage> mSelectedImagesList;
    private LinearLayout mSelectedImagesContainer;
    private LinearLayout mFrameLayout;
    private TextView mSelectedImageEmptyMessage;
    private TextView mSelectedImages;
    private ActionBar mActionBar;
    private File mFile;
    private String mCurrentImagePath = null;
    private int mPicActionMode;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_image_picker);
        this.mSelectedImagesContainer = (LinearLayout)this.findViewById(R.id.selected_photos_container);
        this.mSelectedImages = (TextView)this.findViewById(R.id.txv_total_selected_image);
        this.mSelectedImageEmptyMessage = (TextView)this.findViewById(R.id.selected_photos_empty);
        this.mFrameLayout = (LinearLayout)this.findViewById(R.id.selected_photos_container_frame);
        this.mGalleryGridView = (RecyclerView)this.findViewById(R.id.recycler_view);
        GridLayoutManager manager = new GridLayoutManager((Context)this, 3);
        this.mAdapter = new GalleryGridAdapter(this, this.mGalleyImageCol);
        this.mGalleryGridView.setLayoutManager((RecyclerView.LayoutManager)manager);
        this.mGalleryGridView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mAdapter.setListener(this);
        Intent intent = this.getIntent();
        this.mPicActionMode = intent.getIntExtra(ACTION_MODE, 10001);
        this.mMaxImage = intent.getIntExtra(MAX_IMAGE, -1);
        this.setGalleryImageInGrid();
        this.setActionBar();
    }

    private void setGalleryImageInGrid() {
        this.mSelectedImagesList = new HashSet<GalleryImage>();
        String[] columns = new String[]{"_data", "_id", "orientation"};
        String orderBy = "_id";
        Cursor imageCursor = this.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, columns, null, null, "_id");
        while (imageCursor.moveToNext()) {
            String stringUri;
            int columnIndex = imageCursor.getColumnIndex("_data");
            if (columnIndex == -1 || columnIndex >= imageCursor.getColumnCount() || TextUtils.isEmpty((CharSequence)(stringUri = imageCursor.getString(columnIndex)))) continue;
            Uri uri = Uri.parse((String)stringUri);
            int orientationIndex = imageCursor.getColumnIndex("orientation");
            int orientation = 1;
            if (orientationIndex != -1 && orientationIndex < imageCursor.getColumnCount()) {
                orientation = imageCursor.getInt(orientationIndex);
            }
            this.mGalleyImageCol.add(new GalleryImage(uri, orientation));
        }
        imageCursor.close();
        this.mAdapter.notifyDataSetChanged();
    }

    private void setActionBar() {
        this.mActionBar = (ActionBar)this.findViewById(R.id.cab_multi_picker_custom_action_bar);
        this.mActionBar.setImagePickerActionBarClickListener(this);
        this.mActionBar.setBackButtonVisibility(0);
        this.mActionBar.setDoneButtonVisibility(0);
        this.setActionBarTextAndSelectedImageListVisibility();
    }

    private void setActionBarTextAndSelectedImageListVisibility() {
        this.mActionBar.setTitleVisibility(0);
        this.mActionBar.setTitleText(this.getString(R.string.select_image));
        switch (this.mPicActionMode) {
            case 1: {
                this.mActionBar.setDoneButtonVisibility(8);
                this.mFrameLayout.setVisibility(8);
                break;
            }
            case 10001: {
                this.mFrameLayout.setVisibility(0);
                break;
            }
            default: {
                if (this.mPicActionMode < 0) {
                    this.mFrameLayout.setVisibility(8);
                    break;
                }
                this.mActionBar.setDoneButtonVisibility(8);
                this.mFrameLayout.setVisibility(0);
            }
        }
    }

    public boolean addImageInContainer(GalleryImage image) {
        if (image != null && image.mUri != null && this.mSelectedImagesList.add(image)) {
            this.updateState();
            View rootView = LayoutInflater.from((Context)this).inflate(R.layout.item_selected_thumbnail, null);
            ImageView thumbnail = (ImageView)rootView.findViewById(R.id.selected_photo);
            rootView.setTag((Object)image.mUri);
            this.mFile = new File(image.mUri.getPath());
            String path = "file:" + this.mFile.getAbsolutePath();
            Picasso.with((Context)this).load(path).fit().centerCrop().into(thumbnail);
            this.mSelectedImagesContainer.addView(rootView, 0);
            int px = (int)TypedValue.applyDimension((int)1, (float)60.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            thumbnail.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(px, px));
            if (this.mSelectedImagesList.size() == 1) {
                this.mSelectedImagesContainer.setVisibility(0);
                this.mSelectedImageEmptyMessage.setVisibility(8);
            }
            return true;
        }
        return false;
    }

    private void updateState() {
        this.toggleCamera();
        this.updateImagesCount();
    }

    public boolean removeImageFromContainer(GalleryImage image) {
        if (this.mSelectedImagesList.remove(image)) {
            this.updateState();
            for (int i = 0; i < this.mSelectedImagesContainer.getChildCount(); ++i) {
                View childView = this.mSelectedImagesContainer.getChildAt(i);
                if (!childView.getTag().equals(image.mUri)) continue;
                this.mSelectedImagesContainer.removeViewAt(i);
                break;
            }
            if (this.mSelectedImagesList.size() == 0) {
                this.mSelectedImagesContainer.setVisibility(8);
                this.mSelectedImageEmptyMessage.setVisibility(0);
            }
            return true;
        }
        return false;
    }

    public boolean containsImage(GalleryImage image) {
        return this.mSelectedImagesList.contains(image);
    }

    @Override
    public void onImagePickerActionButtonClick(int clickButtonId) {
        switch (clickButtonId) {
            case 1: {
                this.onDoneButtonClick();
                break;
            }
            case 2: {
                this.setResult(0);
                this.finish();
                break;
            }
            case 3: {
                if (!this.isValidSelection()) break;
                try {
                    Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
                    this.mFile = this.createImageFile();
                    cameraIntent.putExtra("output", (Parcelable)Uri.fromFile((File)this.mFile));
                    cameraIntent.putExtra("return-data", true);
                    this.startActivityForResult(cameraIntent, 100100);
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean isValidSelection() {
        boolean isValid;
        boolean bl = isValid = this.mMaxImage == -1 || this.mMaxImage > this.mSelectedImagesList.size();
        if (!isValid) {
            String image = this.mMaxImage == 1 ? "image" : "images";
            String message = String.format(Locale.getDefault(), this.getString(R.string.max_image_allowed), String.valueOf(this.mMaxImage));
            message = message.replace("images", image);
            DialogUtil.showAlertDialog((Context)this, "Alert", message, null, this.getString(R.string.ok), true, null);
        }
        return isValid;
    }

    private void toggleCamera() {
        if (this.mMaxImage == -1 || this.mMaxImage > this.mSelectedImagesList.size()) {
            this.mActionBar.setCameraButtonVisibility(0);
        } else {
            this.mActionBar.setCameraButtonVisibility(4);
        }
    }

    private void onDoneButtonClick() {
        Uri[] uris = new Uri[this.mSelectedImagesList.size()];
        int i = 0;
        for (GalleryImage img : this.mSelectedImagesList) {
            uris[i++] = img.mUri;
        }
        Intent intent = new Intent();
        intent.putExtra(TAG_IMAGE_URI, (Parcelable[])uris);
        this.setResult(-1, intent);
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100100 && resultCode == -1 && this.mFile != null) {
            Uri[] uris = new Uri[]{Uri.fromFile((File)this.mFile)};
            GalleryImage image = new GalleryImage(uris[0], 0);
            this.mGalleyImageCol.add(0, image);
            this.mAdapter.notifyDataSetChanged();
            this.addImageInContainer(image);
        }
    }

    private void ImageClickAction(GalleryImage image) {
        switch (this.mPicActionMode) {
            case 1: {
                this.onDoneButtonClick();
                break;
            }
            case 10001: {
                break;
            }
            default: {
                if (this.mPicActionMode < 0) {
                    this.onDoneButtonClick();
                    break;
                }
                if (this.mPicActionMode <= this.mSelectedImagesList.size()) break;
                this.removeImageFromContainer(image);
                Toast.makeText((Context)this, (CharSequence)("You can not selected more than" + this.mSelectedImagesList.size() + "images"), (int)0).show();
            }
        }
    }

    private void updateImagesCount() {
        String selection = this.getString(R.string.select_image);
        int size = this.mSelectedImagesList.size();
        if (size > 0) {
            selection = String.format(this.getString(R.string.selected_images), String.valueOf(size));
        }
        this.mSelectedImages.setText((CharSequence)selection);
    }

    @Override
    public void onItemClick(View itemView, int position) {
        GalleryImage image = this.mGalleyImageCol.get(position);
        if (this.mSelectedImagesList.contains(image) || this.isValidSelection()) {
            if (!this.addImageInContainer(image)) {
                this.removeImageFromContainer(image);
            }
            this.ImageClickAction(image);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private File createImageFile() throws IOException {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        File image = File.createTempFile(imageFileName, ".jpg", storageDir);
        return image;
    }
}

