/*
 * Decompiled with CFR 0.152.
 */
package com.avigoyal.imagepick;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.avigoyal.imagepick.ImagePickerActivity;
import com.avigoyal.imagepick.OnRecyclerItemClickListener;
import com.avigoyal.imagepick.R;
import com.avigoyal.imagepick.model.GalleryImage;
import com.squareup.picasso.Picasso;
import java.io.File;
import java.util.ArrayList;

public class GalleryGridAdapter
extends RecyclerView.Adapter<GalleryHolder> {
    private ArrayList<GalleryImage> mData;
    private ImagePickerActivity mActivity;
    protected OnRecyclerItemClickListener mListener;

    public GalleryGridAdapter(ImagePickerActivity activity, ArrayList<GalleryImage> data) {
        this.mActivity = activity;
        this.mData = data;
    }

    public GalleryHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View parentView = LayoutInflater.from((Context)this.mActivity).inflate(R.layout.grid_item_thumbnail, parent, false);
        return new GalleryHolder(parentView);
    }

    public void onBindViewHolder(GalleryHolder holder, int position) {
        GalleryImage image = this.getItem(position);
        boolean isSelected = this.mActivity.containsImage(image);
        ((FrameLayout)holder.itemView).setForeground(isSelected ? this.mActivity.getResources().getDrawable(R.drawable.gallery_photo_selected) : null);
        if (null != image && null != image.mUri && !TextUtils.isEmpty((CharSequence)image.mUri.getPath())) {
            File file = new File(image.mUri.getPath());
            String path = "file:" + file.getAbsolutePath();
            if (!TextUtils.isEmpty((CharSequence)path)) {
                Picasso.with((Context)this.mActivity).load(path).resize(250, 250).centerCrop().into(holder.mThumbnail);
            }
        } else {
            holder.mThumbnail.setImageResource(R.drawable.img_placeholder);
        }
    }

    public int getItemCount() {
        return this.mData.size();
    }

    public GalleryImage getItem(int position) {
        return this.mData.get(position);
    }

    public void setListener(OnRecyclerItemClickListener listener) {
        this.mListener = listener;
    }

    public class GalleryHolder
    extends RecyclerView.ViewHolder {
        final ImageView mThumbnail;

        public GalleryHolder(final View itemView) {
            super(itemView);
            this.mThumbnail = (ImageView)itemView.findViewById(R.id.thumbnail_image);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (GalleryGridAdapter.this.mListener != null) {
                        GalleryGridAdapter.this.mListener.onItemClick(itemView, GalleryHolder.this.getPosition());
                    }
                }
            });
        }
    }
}

