/*
 * Decompiled with CFR 0.152.
 */
package com.avi.contacts.core.multithreading;

import android.os.Handler;
import android.os.Looper;
import java.util.Timer;
import java.util.TimerTask;

public final class TaskScheduler {
    private long mStartTime;
    private long mDelay;
    private Timer mTaskExecutor;
    private final OnTaskStateListener mListener;

    public TaskScheduler(long delay, OnTaskStateListener listener) {
        this.mListener = listener;
        this.mStartTime = System.currentTimeMillis();
        this.mDelay = delay;
        Task task = new Task(this.mListener);
        this.mTaskExecutor = new Timer();
        this.mTaskExecutor.schedule((TimerTask)task, this.mDelay);
    }

    public final void stop() {
        if (System.currentTimeMillis() < this.mStartTime + this.mDelay) {
            this.mTaskExecutor.cancel();
            this.mListener.onStop();
            this.mListener.onFinish();
        }
        this.mTaskExecutor = null;
    }

    public final void cancel() {
        this.mTaskExecutor.cancel();
        this.mListener.onCancel();
    }

    private static class Task
    extends TimerTask {
        private final OnTaskStateListener mListener;

        private Task(OnTaskStateListener listener) {
            this.mListener = listener;
        }

        @Override
        public void run() {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    Task.this.mListener.onComplete();
                    Task.this.mListener.onFinish();
                }
            });
        }
    }

    public static class OnTaskStateListener {
        public void onStop() {
        }

        public void onComplete() {
        }

        public void onCancel() {
        }

        public void onFinish() {
        }
    }
}

