/*
 * Decompiled with CFR 0.152.
 */
package com.avi.contacts;

import android.content.Context;
import com.avi.contacts.model.ContactInfo;
import com.avi.contacts.model.ContactQueryType;
import java.util.ArrayList;

public class ContactQuery {
    public static final int LIMIT = 500;
    private Context mContext;
    private ContactQueryType mQueryType;
    private boolean mIsPaginatedRequired;
    private boolean mIsRequiredLatestResult;
    private ContactsResponseListener<ArrayList<ContactInfo>> mContactsResponseListener;

    public Context getContext() {
        return this.mContext;
    }

    public ContactQueryType getQueryType() {
        return this.mQueryType;
    }

    public boolean isPaginatedRequired() {
        return this.mIsPaginatedRequired;
    }

    public boolean isRequiredLatestResult() {
        return this.mIsRequiredLatestResult;
    }

    public ContactsResponseListener<ArrayList<ContactInfo>> getListener() {
        return this.mContactsResponseListener;
    }

    private ContactQuery(ContactQueryType queryType) {
        this.mQueryType = queryType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactQuery that = (ContactQuery)o;
        return this.mIsPaginatedRequired == that.mIsPaginatedRequired && this.mIsRequiredLatestResult == that.mIsRequiredLatestResult && this.mQueryType == that.mQueryType && (this.mContactsResponseListener != null ? this.mContactsResponseListener.equals(that.mContactsResponseListener) : that.mContactsResponseListener == null);
    }

    public int hashCode() {
        int result = this.mQueryType.hashCode();
        result = 31 * result + (this.mIsPaginatedRequired ? 1 : 0);
        result = 31 * result + (this.mIsRequiredLatestResult ? 1 : 0);
        result = 31 * result + (this.mContactsResponseListener != null ? this.mContactsResponseListener.hashCode() : 0);
        return result;
    }

    public static interface ContactsResponseListener<RESULT> {
        public void onContactsResponse(RESULT var1);
    }

    public static class Builder {
        private final ContactQuery mContactQuery;

        public Builder(ContactQueryType queryType) {
            if (null == queryType) {
                throw new IllegalArgumentException("Contact Query Type can't be null");
            }
            this.mContactQuery = new ContactQuery(queryType);
        }

        public Builder withPaginationRequired(boolean isPaginated) {
            this.mContactQuery.mIsPaginatedRequired = isPaginated;
            return this;
        }

        public Builder withRequiredLatestResult(boolean isRequiredLatestResult) {
            this.mContactQuery.mIsRequiredLatestResult = isRequiredLatestResult;
            return this;
        }

        public Builder withResponseListener(ContactsResponseListener<ArrayList<ContactInfo>> listener) {
            this.mContactQuery.mContactsResponseListener = listener;
            return this;
        }

        public ContactQuery build(Context context) {
            if (null == context) {
                throw new IllegalArgumentException("Context can't be null");
            }
            this.mContactQuery.mContext = context;
            return this.mContactQuery;
        }
    }
}

