/*
 * Decompiled with CFR 0.152.
 */
package com.avi.contacts.model;

import android.text.TextUtils;
import com.avi.contacts.model.Exclude;
import com.avi.contacts.model.LabeledData;
import com.avi.contacts.model.Searchable;
import java.util.ArrayList;
import java.util.Arrays;

public class ContactInfo
implements Searchable {
    private String mFirstName;
    private String mLastName;
    private String mPhoneNumber;
    private String mProfilePhotoUrl;
    private String mProfileThumbnailUrl;
    @Exclude
    private String mEmailId;
    @Exclude
    private String mLabel;
    @Exclude
    private String mIdentity;
    @Exclude
    private ArrayList<LabeledData> mLabeledDataList;

    public ContactInfo(String firstName, String lastName, String phoneNumber) {
        this.mFirstName = firstName;
        this.mLastName = lastName;
        this.mPhoneNumber = phoneNumber;
        this.mIdentity = phoneNumber;
    }

    public String getFirstName() {
        return this.mFirstName;
    }

    public void setFirstName(String firstName) {
        this.mFirstName = firstName;
    }

    public String getLastName() {
        return this.mLastName;
    }

    public void setLastName(String lastName) {
        this.mLastName = lastName;
    }

    public String getPhoneNumber() {
        return this.mPhoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.mIdentity = this.mPhoneNumber = phoneNumber;
    }

    public String getProfilePhotoUrl() {
        return this.mProfilePhotoUrl;
    }

    public void setProfilePhotoUrl(String profilePhotoUrl) {
        this.mProfilePhotoUrl = profilePhotoUrl;
    }

    public String getProfileThumbnailUrl() {
        return this.mProfileThumbnailUrl;
    }

    public void setProfileThumbnailUrl(String profileThumbnailUrl) {
        this.mProfileThumbnailUrl = profileThumbnailUrl;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public void setLabel(String label) {
        this.mLabel = label;
    }

    public String getEmailId() {
        return this.mEmailId;
    }

    public void setEmailId(String emailId) {
        this.mEmailId = emailId;
        if (!TextUtils.isEmpty((CharSequence)this.mEmailId) && (TextUtils.isEmpty((CharSequence)this.mIdentity) || null != this.mPhoneNumber && !this.mIdentity.equals(this.mPhoneNumber))) {
            this.mIdentity = this.mEmailId;
        }
        if (TextUtils.isEmpty((CharSequence)this.mIdentity)) {
            this.mIdentity = this.mEmailId;
        }
    }

    public String getIdentity() {
        return this.mIdentity != null ? this.mIdentity : (null != this.mPhoneNumber ? this.mPhoneNumber : (null != this.mEmailId ? this.mEmailId : null));
    }

    public String toString() {
        return this.mFirstName + ", " + this.mPhoneNumber;
    }

    public void setLabeledDataList(LabeledData ... labeledDataList) {
        this.setLabeledDataList(new ArrayList<LabeledData>(Arrays.asList(labeledDataList)));
    }

    public void setLabeledDataList(ArrayList<LabeledData> labeledDataList) {
        StringBuilder identity = new StringBuilder();
        if (!labeledDataList.isEmpty()) {
            this.mLabeledDataList = labeledDataList;
            identity.append(this.mLabeledDataList.get((int)0).mData);
            for (int i = 0; i < labeledDataList.size(); ++i) {
                LabeledData labeledData = labeledDataList.get(i);
                identity.append(", ").append(labeledData.mData);
            }
            this.mIdentity = String.valueOf(identity);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactInfo contactInfo = (ContactInfo)o;
        return this.getIdentity() != null ? this.getIdentity().equals(contactInfo.getIdentity()) : contactInfo.getIdentity() == null;
    }

    public int hashCode() {
        return this.mIdentity != null ? this.mIdentity.hashCode() : 0;
    }

    @Override
    public boolean contain(CharSequence searchString) {
        boolean found = false;
        if (null != this.mFirstName) {
            found = this.mFirstName.toLowerCase().contains(String.valueOf(searchString).toLowerCase());
        }
        if (!found && null != this.mLastName) {
            found = this.mLastName.toLowerCase().contains(String.valueOf(searchString).toLowerCase());
        }
        return found;
    }
}

