/*
 * Decompiled with CFR 0.152.
 */
package com.avi.contacts.core.multithreading;

import android.os.Handler;
import android.os.Looper;
import com.avi.contacts.core.OnDataListener;
import com.avi.contacts.core.logs.Logger;
import com.avi.contacts.core.logs.LoggerFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class BackgroundManager {
    private static final Logger LOGGER = LoggerFactory.createLogger(BackgroundManager.class);
    private static final int EXECUTOR_THREAD_COUNT = 2;
    private static volatile BackgroundManager sInstance;
    private ExecutorService mSingleExecutor;
    private ExecutorService mExecutor;
    private ScheduledExecutorService mScheduledExecutorService;
    private ExecutorService mTaskScheduler;
    private Handler mHandler = new Handler(Looper.getMainLooper());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BackgroundManager getInstance() {
        if (null != sInstance) return sInstance;
        Class<BackgroundManager> clazz = BackgroundManager.class;
        synchronized (BackgroundManager.class) {
            sInstance = new BackgroundManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private BackgroundManager() {
        this.mSingleExecutor = Executors.newSingleThreadExecutor();
        this.mExecutor = Executors.newFixedThreadPool(2);
        this.mTaskScheduler = Executors.newCachedThreadPool();
        this.mScheduledExecutorService = Executors.newScheduledThreadPool(1);
    }

    public synchronized void runInBackground(Runnable r) {
        this.mExecutor.execute(r);
    }

    public synchronized void runInBackground(Runnable r, long delay) {
        this.mScheduledExecutorService.schedule(r, delay, TimeUnit.MILLISECONDS);
    }

    public synchronized void runInSingleThreadedQueue(Runnable r) {
        this.mSingleExecutor.submit(r);
    }

    public synchronized <T> Future<T> runInSingleThreadedQueue(Callable<T> callable) {
        return this.mSingleExecutor.submit(callable);
    }

    public synchronized void postDelayed(Runnable runnable, long delay) {
        this.mHandler.postDelayed(runnable, delay);
    }

    public synchronized void runOnMainThread(Runnable r) {
        this.mHandler.post(r);
    }

    public synchronized <T> Future schedule(final OnDataListener<T> listener, final T data, final long delay) {
        LOGGER.info("Submitted a task with delay %s", delay);
        return this.mTaskScheduler.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(delay);
                    listener.onResult(data);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public synchronized <T> Future scheduleOnMainThread(final OnDataListener<T> listener, final T data, final long delay) {
        LOGGER.info("Submitted a task with delay %s", delay);
        return this.mTaskScheduler.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(delay);
                    BackgroundManager.this.postOnMainThread(listener, data);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public synchronized <T> void postOnMainThread(final OnDataListener<T> listener, final T data) {
        if (null != listener) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    listener.onResult(data);
                }
            });
        }
    }

    public synchronized Handler getHandler() {
        return this.mHandler;
    }

    public synchronized void terminateAll() {
        try {
            if (!(null == this.mSingleExecutor || this.mSingleExecutor.isShutdown() && this.mSingleExecutor.isTerminated())) {
                this.mSingleExecutor.shutdownNow();
            }
            if (!(null == this.mExecutor || this.mExecutor.isShutdown() && this.mExecutor.isTerminated())) {
                this.mExecutor.shutdownNow();
            }
            if (!(null == this.mTaskScheduler || this.mTaskScheduler.isShutdown() && this.mTaskScheduler.isTerminated())) {
                this.mTaskScheduler.shutdownNow();
            }
            if (null != this.mHandler) {
                this.mHandler.removeCallbacksAndMessages(null);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getLocalizedMessage(), new Object[0]);
        }
    }
}

