/*
 * Decompiled with CFR 0.152.
 */
package com.avi.contacts.core.logs;

import android.util.Log;

public class Logger {
    private final String mClassName;
    private final boolean mLoggable;
    private static boolean sIsDebug;

    public Logger(String mClassName) {
        boolean androidLog;
        this.mClassName = mClassName;
        try {
            Class.forName("android.util.Log");
            androidLog = true;
        }
        catch (ClassNotFoundException e) {
            androidLog = false;
        }
        this.mLoggable = sIsDebug && androidLog;
    }

    public void debug(String format, Object ... arguments) {
        if (this.mLoggable) {
            try {
                Log.d((String)this.mClassName, (String)String.format(format, arguments));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.mLoggable) {
            try {
                Log.e((String)this.mClassName, (String)String.format(format, arguments));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.mLoggable) {
            try {
                Log.i((String)this.mClassName, (String)String.format(format, arguments));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void verbose(String format, Object ... arguments) {
        if (this.mLoggable) {
            try {
                Log.v((String)this.mClassName, (String)String.format(format, arguments));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.mLoggable) {
            try {
                Log.w((String)this.mClassName, (String)String.format(format, arguments));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void setIsDebug(boolean isDebug) {
        sIsDebug = isDebug;
    }

    public static boolean isDebug() {
        return sIsDebug;
    }
}

