/*
 * Decompiled with CFR 0.152.
 */
package com.avi.contacts;

import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import android.text.TextUtils;
import com.avi.contacts.ContactQuery;
import com.avi.contacts.contactentitytype.ContactType;
import com.avi.contacts.contactentitytype.Email;
import com.avi.contacts.contactentitytype.Phone;
import com.avi.contacts.core.OnDataListener;
import com.avi.contacts.core.logs.Logger;
import com.avi.contacts.core.logs.LoggerFactory;
import com.avi.contacts.core.multithreading.BackgroundManager;
import com.avi.contacts.model.ContactInfo;
import com.avi.contacts.model.ContactQueryType;
import com.avi.contacts.model.LabeledData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;

public class ContactsFetchManager {
    public static final Logger LOGGER = LoggerFactory.createLogger(ContactsFetchManager.class);
    private static ContactsFetchManager sInstance;
    private HashMap<String, LinkedHashSet<LabeledData>> mLabeledDataContactList = new HashMap();
    private ArrayList<ContactQuery> mContactQueries = new ArrayList();
    private boolean mIsRunning = false;
    private boolean mIsFetched = false;

    private ContactsFetchManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContactsFetchManager getInstance() {
        if (null != sInstance) return sInstance;
        Class<ContactsFetchManager> clazz = ContactsFetchManager.class;
        synchronized (ContactsFetchManager.class) {
            sInstance = new ContactsFetchManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public synchronized boolean fetchContacts(ContactQuery contactQuery) {
        if (null == contactQuery) {
            throw new IllegalArgumentException("ContactQuery can't be null for the contact fetching");
        }
        if (!this.mContactQueries.contains(contactQuery)) {
            this.mContactQueries.add(contactQuery);
        }
        if (!(this.mIsRunning || !contactQuery.isRequiredLatestResult() && this.mIsFetched)) {
            ContentResolver cr = contactQuery.getContext().getContentResolver();
            if (null == cr) {
                return false;
            }
            this.mIsRunning = true;
            this.mIsFetched = false;
            BackgroundManager.getInstance().runInBackground(new ContactFetchingRunnable(cr, new ContactFetchCallback()));
            return true;
        }
        if (this.mIsFetched) {
            this.passFetchedContactsToRegisterQuery();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeContactsTypeQuery(ContentResolver cr, ContactType contactType, HashMap<String, LinkedHashSet<LabeledData>> labeledDataList) {
        Uri contentUri = this.getContentUri(contactType);
        if (null == contentUri) {
            return;
        }
        boolean hasContacts = true;
        Cursor cursor = null;
        int offset = 0;
        int limit = 500;
        while (hasContacts) {
            LabeledData data;
            String rawId;
            int count = 0;
            try {
                cursor = cr.query(contentUri, null, null, null, "display_name" + String.format(" ASC LIMIT %s OFFSET %s", limit, offset));
            }
            catch (Exception e) {
                try {
                    LOGGER.error("Contacts fetching error %s", e.getMessage());
                }
                catch (Throwable throwable) {
                    if (null != cursor && cursor.moveToFirst() && (count = cursor.getCount()) > 0) {
                        do {
                            int indexRawId;
                            if (!ContactsFetchManager.isValidIndex(indexRawId = cursor.getColumnIndex(this.getRawIndex(contactType)))) continue;
                            String rawId2 = cursor.getString(indexRawId);
                            LabeledData data2 = this.extractData(cursor, contactType);
                            this.populateWithLabeledData(labeledDataList, rawId2, data2);
                            LOGGER.info("Id :- %s ", rawId2);
                        } while (cursor.moveToNext());
                    }
                    if (null != cursor) {
                        cursor.close();
                    }
                    throw throwable;
                }
                if (null != cursor && cursor.moveToFirst() && (count = cursor.getCount()) > 0) {
                    do {
                        int indexRawId;
                        if (!ContactsFetchManager.isValidIndex(indexRawId = cursor.getColumnIndex(this.getRawIndex(contactType)))) continue;
                        rawId = cursor.getString(indexRawId);
                        data = this.extractData(cursor, contactType);
                        this.populateWithLabeledData(labeledDataList, rawId, data);
                        LOGGER.info("Id :- %s ", rawId);
                    } while (cursor.moveToNext());
                }
                if (null != cursor) {
                    cursor.close();
                }
            }
            if (null != cursor && cursor.moveToFirst() && (count = cursor.getCount()) > 0) {
                do {
                    int indexRawId;
                    if (!ContactsFetchManager.isValidIndex(indexRawId = cursor.getColumnIndex(this.getRawIndex(contactType)))) continue;
                    rawId = cursor.getString(indexRawId);
                    data = this.extractData(cursor, contactType);
                    this.populateWithLabeledData(labeledDataList, rawId, data);
                    LOGGER.info("Id :- %s ", rawId);
                } while (cursor.moveToNext());
            }
            if (null != cursor) {
                cursor.close();
            }
            if (count >= limit) {
                offset = limit;
                limit += 500;
                continue;
            }
            hasContacts = false;
        }
    }

    private void passFetchedContactsToRegisterQuery() {
        HashMap<ContactQueryType, LinkedHashSet<ContactInfo>> contactsMap = this.extractContactsMap(this.mLabeledDataContactList);
        for (ContactQuery contactQuery : this.mContactQueries) {
            LinkedHashSet<ContactInfo> contactInfos = contactsMap.get((Object)contactQuery.getQueryType());
            ContactQuery.ContactsResponseListener<ArrayList<ContactInfo>> listener = contactQuery.getListener();
            if (null == listener || null == contactInfos) continue;
            listener.onContactsResponse(new ArrayList<ContactInfo>(contactInfos));
        }
        this.mContactQueries.clear();
    }

    private void passFetchedPaginatedContactsToRegisterQuery() {
        HashMap<ContactQueryType, LinkedHashSet<ContactInfo>> contactsMap = this.extractContactsMap(this.mLabeledDataContactList);
        for (ContactQuery contactQuery : this.mContactQueries) {
            LinkedHashSet<ContactInfo> contactInfos = contactsMap.get((Object)contactQuery.getQueryType());
            ContactQuery.ContactsResponseListener<ArrayList<ContactInfo>> listener = contactQuery.getListener();
            if (null == listener || null == contactInfos) continue;
            listener.onContactsResponse(new ArrayList<ContactInfo>(contactInfos));
        }
    }

    private LabeledData extractData(Cursor cursor, ContactType contactType) {
        LabeledData data = null;
        switch (contactType) {
            case EMAIL: {
                data = Email.extractEmail(cursor);
                break;
            }
            case NUMBER: {
                data = Phone.extractPhoneNumber(cursor);
            }
        }
        return data;
    }

    private void populateWithLabeledData(HashMap<String, LinkedHashSet<LabeledData>> labeledDataList, String rawId, LabeledData data) {
        if (null != data) {
            LinkedHashSet<LabeledData> labeledData = labeledDataList.get(rawId);
            if (null == labeledData) {
                labeledData = new LinkedHashSet();
                labeledDataList.put(rawId, labeledData);
            }
            labeledData.add(data);
        }
    }

    private String getRawIndex(ContactType contactType) {
        switch (contactType) {
            case EMAIL: {
                return "raw_contact_id";
            }
            case NUMBER: {
                return "raw_contact_id";
            }
        }
        return "raw_contact_id";
    }

    private Uri getContentUri(ContactType contactType) {
        switch (contactType) {
            case EMAIL: {
                return ContactsContract.CommonDataKinds.Email.CONTENT_URI;
            }
            case NUMBER: {
                return ContactsContract.CommonDataKinds.Phone.CONTENT_URI;
            }
        }
        return null;
    }

    public void addLabelData(String key, LabeledData labeledData) {
        LinkedHashSet<LabeledData> labels = this.mLabeledDataContactList.get(key);
        if (null == labels) {
            labels = new LinkedHashSet();
            this.mLabeledDataContactList.put(key, labels);
        }
        labels.add(labeledData);
    }

    private HashMap<ContactQueryType, LinkedHashSet<ContactInfo>> extractContactsMap(HashMap<String, LinkedHashSet<LabeledData>> mappedContactLabeledList) {
        String name = null;
        HashMap<ContactQueryType, LinkedHashSet<ContactInfo>> contacts = new HashMap<ContactQueryType, LinkedHashSet<ContactInfo>>();
        for (ContactQueryType contactQueryType : ContactQueryType.values()) {
            contacts.put(contactQueryType, new LinkedHashSet());
        }
        LinkedHashSet combinedEmail = (LinkedHashSet)contacts.get((Object)ContactQueryType.COMBINED_EMAIL);
        LinkedHashSet combinedNumbers = (LinkedHashSet)contacts.get((Object)ContactQueryType.COMBINED_PHONE);
        LinkedHashSet multipleNumbers = (LinkedHashSet)contacts.get((Object)ContactQueryType.MULTIPLE_PHONE);
        LinkedHashSet multipleEmail = (LinkedHashSet)contacts.get((Object)ContactQueryType.MULTIPLE_EMAIL);
        LinkedHashSet combinedContactInfos = (LinkedHashSet)contacts.get((Object)ContactQueryType.COMBINED_EMAIL_PHONE);
        LinkedHashSet allPhoneEmail = (LinkedHashSet)contacts.get((Object)ContactQueryType.ALL_PHONE_EMAIL);
        for (LinkedHashSet<LabeledData> labelDataList : mappedContactLabeledList.values()) {
            ArrayList<LabeledData> emailOnlyData = new ArrayList<LabeledData>();
            ArrayList<LabeledData> numberOnlyData = new ArrayList<LabeledData>();
            for (LabeledData labeledData : labelDataList) {
                name = TextUtils.isEmpty((CharSequence)labeledData.mName) ? name : labeledData.mName;
                ContactInfo contactInfo = new ContactInfo(labeledData.mName, null, null);
                switch (labeledData.mDataType) {
                    case EMAIL: {
                        emailOnlyData.add(labeledData);
                        contactInfo.setEmailId(labeledData.mData);
                        contactInfo.setLabel(labeledData.mLabel);
                        contactInfo.setLabeledDataList(labeledData);
                        allPhoneEmail.add(contactInfo);
                        multipleEmail.add(contactInfo);
                        break;
                    }
                    case NUMBER: {
                        numberOnlyData.add(labeledData);
                        contactInfo.setPhoneNumber(labeledData.mData);
                        contactInfo.setLabel(labeledData.mLabel);
                        contactInfo.setLabeledDataList(labeledData);
                        allPhoneEmail.add(contactInfo);
                        multipleNumbers.add(contactInfo);
                    }
                }
            }
            if (!emailOnlyData.isEmpty()) {
                ContactInfo combinedEmailInfo = new ContactInfo(name, null, null);
                combinedEmailInfo.setLabeledDataList(new ArrayList<LabeledData>(emailOnlyData));
                combinedEmail.add(combinedEmailInfo);
            }
            if (!numberOnlyData.isEmpty()) {
                ContactInfo combinedNumberInfo = new ContactInfo(name, null, null);
                combinedNumberInfo.setLabeledDataList(new ArrayList<LabeledData>(numberOnlyData));
                combinedNumbers.add(combinedNumberInfo);
            }
            ContactInfo combinedContactInfo = new ContactInfo(name, null, null);
            combinedContactInfo.setLabeledDataList(new ArrayList<LabeledData>(labelDataList));
            combinedContactInfos.add(combinedContactInfo);
        }
        return contacts;
    }

    private void transferData(HashMap<ContactQueryType, LinkedHashSet<ContactInfo>> contacts, ContactQuery.ContactsResponseListener<HashMap<ContactQueryType, LinkedHashSet<ContactInfo>>> contactFetchListener) {
        if (null != contactFetchListener) {
            contactFetchListener.onContactsResponse(contacts);
        }
    }

    public static boolean isValidIndex(int pIdIndex) {
        return -1 != pIdIndex;
    }

    private class ContactFetchCallback
    implements OnDataListener<HashMap<String, LinkedHashSet<LabeledData>>> {
        private ContactFetchCallback() {
        }

        @Override
        public void onResult(HashMap<String, LinkedHashSet<LabeledData>> labelData) {
            if (!labelData.isEmpty()) {
                ContactsFetchManager.this.mLabeledDataContactList.clear();
                ContactsFetchManager.this.mLabeledDataContactList.putAll(labelData);
            }
            ContactsFetchManager.this.mIsRunning = false;
            ContactsFetchManager.this.mIsFetched = true;
            ContactsFetchManager.this.passFetchedContactsToRegisterQuery();
        }
    }

    private class ContactFetchingRunnable
    implements Runnable {
        private final ContentResolver mContentResolver;
        private final OnDataListener<HashMap<String, LinkedHashSet<LabeledData>>> mListener;

        public ContactFetchingRunnable(ContentResolver cr, OnDataListener<HashMap<String, LinkedHashSet<LabeledData>>> listener) {
            this.mContentResolver = cr;
            this.mListener = listener;
        }

        @Override
        public void run() {
            HashMap labeledDataContactList = new HashMap();
            for (ContactType contactType : ContactType.values()) {
                ContactsFetchManager.this.executeContactsTypeQuery(this.mContentResolver, contactType, labeledDataContactList);
            }
            BackgroundManager.getInstance().postOnMainThread(this.mListener, labeledDataContactList);
        }
    }
}

