/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.gherkin;

import com.aventstack.extentreports.gherkin.GherkinDialect;
import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GherkinDialectManager {
    private static final Logger LOG = Logger.getLogger(GherkinDialectManager.class.getName());
    private static final String DEFAULT_LANGUAGE = "en";
    private static final String GHERKIN_LANGUAGES_JSON_URL = "https://github.com/cucumber/cucumber/blob/master/gherkin/gherkin-languages.json";
    private static final String GHERKIN_LANGUAGES_PATH = "gherkin-languages.json";
    private static GherkinDialect currentDialect;
    private static Map<String, Map<String, List<String>>> dialects;
    private static String language;

    public static GherkinDialect getDialect() {
        return currentDialect;
    }

    public static String getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    public static String getLanguage() {
        if (language == null || language.isEmpty()) {
            language = DEFAULT_LANGUAGE;
        }
        return language;
    }

    public static void setLanguage(String lang) throws UnsupportedEncodingException {
        language = lang;
        Map<String, List<String>> map = dialects.get(language);
        if (map == null) {
            throw new UnsupportedEncodingException("Invalid language [" + language + "]. See list of supported languages: https://github.com/cucumber/cucumber/blob/master/gherkin/gherkin-languages.json");
        }
        currentDialect = new GherkinDialect(language, map);
    }

    static {
        Gson gson = new Gson();
        try {
            InputStreamReader d = new InputStreamReader(GherkinDialectManager.class.getResourceAsStream(GHERKIN_LANGUAGES_PATH), "UTF-8");
            dialects = (Map)gson.fromJson((Reader)d, Map.class);
        }
        catch (UnsupportedEncodingException e) {
            LOG.log(Level.SEVERE, "Unable to parse Gherkin languages file. Either the file is missing or corrupted.", e);
        }
    }
}

