/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.reporter;

import com.aventstack.extentreports.ReportAggregates;
import com.aventstack.extentreports.reporter.BasicFileReporter;
import com.aventstack.extentreports.reporter.configuration.ExtentHtmlReporterConfiguration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtentHtmlReporter
extends BasicFileReporter {
    private static final Logger logger = Logger.getLogger(ExtentHtmlReporter.class.getName());
    private static final String REPORTER_NAME = "html";
    private static final String TEMPLATE_NAME = "v3html/v3-html-index.ftl";
    private static final String[] DEFAULT_CONFIG_FILE_PATH = new String[]{"html.properties", "src/main/resources/html.properties"};
    private ExtentHtmlReporterConfiguration userConfig = new ExtentHtmlReporterConfiguration(this);

    public ExtentHtmlReporter(String path) {
        super(path);
        this.init(DEFAULT_CONFIG_FILE_PATH, this.config());
    }

    public ExtentHtmlReporter(File file) {
        super(file);
        this.init(DEFAULT_CONFIG_FILE_PATH, this.config());
    }

    public ExtentHtmlReporterConfiguration config() {
        return this.userConfig;
    }

    @Override
    public synchronized void flush(ReportAggregates reportAggregates) {
        super.flush(reportAggregates);
        if (this.getTestList().isEmpty()) {
            return;
        }
        this.loadUserConfig();
        try {
            Template template = this.getFreemarkerConfig().getTemplate(TEMPLATE_NAME);
            this.processTemplate(template, new File(this.filePath));
        }
        catch (TemplateException | IOException e) {
            logger.log(Level.SEVERE, "An exception occurred", e);
        }
    }

    @Override
    public String getReporterName() {
        return REPORTER_NAME;
    }
}

