/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.conf;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private static final String APP_NAME = "chaintest";
    private static final String[] RESOURCES = new String[]{"application.properties", "application-test.properties", "test.properties", "config.properties", "chaintest.properties"};
    private final Map<String, String> _config = new HashMap<String, String>();

    public String get(String prop) {
        return this._config.get(prop);
    }

    public Map<String, String> getConfig() {
        return this._config;
    }

    public void load() throws IOException {
        log.trace("Starting load externalized configuration");
        for (String resource : RESOURCES) {
            this.loadFromClasspathResource(resource);
        }
        System.getenv().forEach((k, v) -> {
            if (k.startsWith(APP_NAME)) {
                log.trace("Adding environment property {} to configuration", k);
                this._config.put((String)k, (String)v);
            }
        });
        this.loadFromProperties(System.getProperties());
    }

    public void loadFromClasspathResource(String resource) throws IOException {
        log.trace("Loading configuration from resource {}", (Object)resource);
        Properties properties = new Properties();
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);){
            if (is != null) {
                properties.load(is);
                this.loadFromProperties(properties);
            }
        }
        log.trace("Configuration entries after loading from resource {}: {}", (Object)resource, this._config);
    }

    public void loadFromProperties(Properties properties) {
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (key.toString().startsWith(APP_NAME)) {
                this._config.put(key.toString(), value.toString());
            }
        }));
    }
}

