/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.domain;

import com.aventstack.chaintest.domain.ChainTestEntity;
import com.aventstack.chaintest.domain.Embed;
import com.aventstack.chaintest.domain.Log;
import com.aventstack.chaintest.domain.Result;
import com.aventstack.chaintest.domain.Tag;
import com.aventstack.chaintest.util.ExceptionsUtil;
import com.aventstack.chaintest.util.TimeUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Test
implements ChainTestEntity {
    private long id;
    private long buildId;
    private long projectId;
    private final UUID clientId = UUID.randomUUID();
    private String externalId;
    private String name;
    private String description;
    private String className;
    private long startedAt = System.currentTimeMillis();
    private long endedAt;
    private long durationMs;
    private String result = Result.PASSED.getResult();
    private final Set<Tag> tags = new HashSet<Tag>();
    private String error;
    private Queue<Test> children = new ConcurrentLinkedQueue<Test>();
    private final List<Log> logs = Collections.synchronizedList(new ArrayList());
    private final List<Embed> embeds = new ArrayList<Embed>();
    private int depth;
    private boolean isBDD;
    @JsonIgnore
    private Test parent;

    public Test() {
    }

    public Test(long buildId, String name, Optional<String> testClass, Collection<String> tags) {
        this.setBuildId(buildId);
        this.setName(name);
        this.addTags(tags);
        testClass.ifPresent(this::setClassName);
    }

    public Test(long buildId, String name, Optional<String> testClass, Stream<String> tags) {
        this.setBuildId(buildId);
        this.setName(name);
        tags.forEach(this::addTag);
        testClass.ifPresent(this::setClassName);
    }

    public Test(String name, Optional<String> testClass, Collection<String> tags) {
        this(0L, name, testClass, tags);
    }

    public Test(String name, Optional<String> testClass, Stream<String> tags) {
        this(0L, name, testClass, tags);
    }

    public Test(long buildId, String name, Optional<String> testClass) {
        this(buildId, name, testClass, Stream.empty());
    }

    public Test(String name, Optional<String> testClass) {
        this(0L, name, testClass);
    }

    public Test(long buildId, String name, Collection<String> tags) {
        this(buildId, name, Optional.empty(), tags);
    }

    public Test(long buildId, String name, Stream<String> tags) {
        this(buildId, name, Optional.empty(), tags);
    }

    public Test(String name, Collection<String> tags) {
        this(0L, name, tags);
    }

    public Test(String name, Stream<String> tags) {
        this(0L, name, tags);
    }

    public Test(long buildId, String name) {
        this(buildId, name, Stream.empty());
    }

    public Test(String name) {
        this.setName(name);
    }

    public Test(long buildId, Method method, Collection<String> tags) {
        this(buildId, method.getName(), tags);
    }

    public Test(Method method, Collection<String> tags) {
        this(0L, method, tags);
    }

    public Test(long buildId, Method method) {
        this(buildId, method.getName());
    }

    public Test(Method method) {
        this(0L, method);
    }

    public void complete() {
        this.complete(Optional.empty());
    }

    public void complete(Optional<Throwable> error) {
        this.setEndedAt(System.currentTimeMillis());
        error.ifPresent(x -> {
            this.setError(ExceptionsUtil.readStackTrace(x));
            this.setResult(Result.FAILED.getResult());
        });
        if (null != this.parent) {
            Result computedResult = Result.computePriority(Result.valueOf(this.getResult()), Result.valueOf(this.parent.getResult()));
            this.parent.setResult(computedResult.getResult());
            this.parent.complete();
        }
    }

    public void complete(Throwable error) {
        this.complete(Optional.ofNullable(error));
    }

    public void setEndedAt(Long endedAt) {
        this.endedAt = endedAt;
        this.setDurationMs(endedAt - this.startedAt);
    }

    public String getDurationPretty() {
        return TimeUtil.getPrettyTime(this.getDurationMs());
    }

    public void addTags(Collection<String> tags) {
        if (null != tags) {
            tags.forEach(this::addTag);
        }
    }

    public void addTag(String tag) {
        if (null != tag && !tag.isBlank()) {
            Tag t = new Tag(tag);
            this.tags.add(t);
            if (null != this.parent) {
                this.parent.addTag(t);
            }
        }
    }

    public void addTag(Tag tag) {
        if (null != tag) {
            this.tags.add(tag);
            if (null != this.parent) {
                this.parent.addTag(tag);
            }
        }
    }

    public void addChild(Test child) {
        child.setParent(this);
        child.setDepth(this.depth + 1);
        child.getTags().forEach(this::addTag);
        this.children.add(child);
    }

    public void addLog(String log) {
        this.logs.add(new Log(log));
    }

    public void setIsBdd(boolean isBDD) {
        this.isBDD = isBDD;
        this.children.forEach(x -> x.setIsBdd(isBDD));
    }

    public void addEmbed(String base64, String mediaType) {
        this.embeds.add(new Embed(base64, mediaType));
    }

    public void addEmbed(File file, String mediaType) {
        this.embeds.add(new Embed(file, mediaType));
    }

    public void addEmbed(byte[] bytes, String mediaType) {
        this.embeds.add(new Embed(bytes, mediaType));
    }

    public void addEmbed(Embed embed) {
        this.embeds.add(embed);
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public long getBuildId() {
        return this.buildId;
    }

    @Generated
    public long getProjectId() {
        return this.projectId;
    }

    @Generated
    public UUID getClientId() {
        return this.clientId;
    }

    @Generated
    public String getExternalId() {
        return this.externalId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public long getStartedAt() {
        return this.startedAt;
    }

    @Generated
    public long getEndedAt() {
        return this.endedAt;
    }

    @Generated
    public long getDurationMs() {
        return this.durationMs;
    }

    @Generated
    public String getResult() {
        return this.result;
    }

    @Generated
    public Set<Tag> getTags() {
        return this.tags;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public Queue<Test> getChildren() {
        return this.children;
    }

    @Generated
    public List<Log> getLogs() {
        return this.logs;
    }

    @Generated
    public List<Embed> getEmbeds() {
        return this.embeds;
    }

    @Generated
    public int getDepth() {
        return this.depth;
    }

    @Generated
    public boolean isBDD() {
        return this.isBDD;
    }

    @Generated
    public Test getParent() {
        return this.parent;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setBuildId(long buildId) {
        this.buildId = buildId;
    }

    @Generated
    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    @Generated
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setClassName(String className) {
        this.className = className;
    }

    @Generated
    public void setStartedAt(long startedAt) {
        this.startedAt = startedAt;
    }

    @Generated
    public void setDurationMs(long durationMs) {
        this.durationMs = durationMs;
    }

    @Generated
    public void setResult(String result) {
        this.result = result;
    }

    @Generated
    public void setError(String error) {
        this.error = error;
    }

    @Generated
    public void setChildren(Queue<Test> children) {
        this.children = children;
    }

    @Generated
    public void setDepth(int depth) {
        this.depth = depth;
    }

    @JsonIgnore
    @Generated
    public void setParent(Test parent) {
        this.parent = parent;
    }
}

