/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.domain;

import java.util.Arrays;

public enum Result {
    UNKNOWN("UNKNOWN", -1),
    PASSED("PASSED", 0),
    UNDEFINED("UNDEFINED", 10),
    SKIPPED("SKIPPED", 20),
    FAILED("FAILED", 30);

    private final String _result;
    private final int _priority;

    private Result(String result, int priority) {
        this._result = result;
        this._priority = priority;
    }

    public String getResult() {
        return this._result;
    }

    public int getPriority() {
        return this._priority;
    }

    public static Result parseResult(String resultString) {
        return Arrays.stream(Result.values()).filter(x -> x.getResult().equalsIgnoreCase(resultString)).findAny().orElse(UNKNOWN);
    }

    public static Result computePriority(Result a, Result b) {
        return a.getPriority() > b.getPriority() ? a : b;
    }

    public static Result computePriority(String a, String b) {
        Result ar = Result.parseResult(a);
        Result br = Result.parseResult(b);
        return Result.computePriority(ar, br);
    }
}

