/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.conf;

import com.aventstack.chaintest.util.RegexUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.yaml.snakeyaml.Yaml;

public class YamlConfig {
    private static final String KEY_PATTERN = "\\$\\{([^}]+)}";
    private Map<String, Object> _yaml;

    private YamlConfig() {
    }

    public static YamlConfig load(InputStream is) {
        Yaml yaml = new Yaml();
        YamlConfig instance = new YamlConfig();
        instance._yaml = (Map)yaml.load(is);
        return instance;
    }

    public static YamlConfig load(String path) throws FileNotFoundException {
        return YamlConfig.load(new FileInputStream(path));
    }

    public Optional<String> getString(String key) {
        Optional<Object> obj = this.getObject(this._yaml, key);
        if (obj.isPresent() && !(obj.get() instanceof Collection)) {
            return Optional.of(obj.get().toString());
        }
        return Optional.empty();
    }

    public Optional<Integer> getInt(String key) {
        Optional<Object> val = this.getObject(key);
        if (val.isPresent() && val.get() instanceof Integer) {
            return Optional.of((Integer)val.get());
        }
        return Optional.empty();
    }

    public Optional<Collection<?>> getCollection(String key) {
        Optional<Object> obj = this.getObject(this._yaml, key);
        if (obj.isPresent() && obj.get() instanceof Collection) {
            return Optional.of((Collection)obj.get());
        }
        return Optional.empty();
    }

    public Optional<Object> getObject(String key) {
        return this.getObject(this._yaml, key);
    }

    private Optional<Object> getObject(Object content, String key) {
        String[] parts;
        String match = RegexUtil.match(KEY_PATTERN, key);
        for (String part : parts = (null == match || match.isEmpty() ? key : match).split("\\.")) {
            if (!(content instanceof Map)) continue;
            content = ((Map)((Object)content)).get(part);
        }
        if (null != content && ((Object)content).toString().matches(KEY_PATTERN)) {
            String subKey = RegexUtil.match(KEY_PATTERN, ((Object)content).toString());
            content = this.getObject(this._yaml, subKey);
        }
        return Optional.of(content);
    }
}

