/*
 * Decompiled with CFR 0.152.
 */
package com.avast.android.dialogs.util;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Checkable;
import android.widget.LinearLayout;
import java.util.HashSet;
import java.util.Set;

public class CheckableLinearLayout
extends LinearLayout
implements Checkable {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private Set<Checkable> mCheckablesSet = new HashSet<Checkable>();
    private boolean mChecked;

    public CheckableLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View v = this.getChildAt(i);
            if (!(v instanceof Checkable)) continue;
            this.mCheckablesSet.add((Checkable)v);
        }
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(boolean checked) {
        if (checked == this.mChecked) {
            return;
        }
        this.mChecked = checked;
        for (Checkable checkable : this.mCheckablesSet) {
            checkable.setChecked(checked);
        }
        this.refreshDrawableState();
    }

    public void toggle() {
        this.setChecked(!this.mChecked);
    }

    public int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            CheckableLinearLayout.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }
}

