/*
 * Decompiled with CFR 0.152.
 */
package com.avast.android.dialogs.core;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import com.avast.android.dialogs.core.BaseDialogFragment;

public abstract class BaseDialogBuilder<T extends BaseDialogBuilder<T>> {
    public static final String ARG_REQUEST_CODE = "request_code";
    public static final String ARG_CANCELABLE_ON_TOUCH_OUTSIDE = "cancelable_oto";
    public static final String DEFAULT_TAG = "simple_dialog";
    private String mTag = "simple_dialog";
    public static final int DEFAULT_REQUEST_CODE = -42;
    private int mRequestCode = -42;
    public static String ARG_USE_DARK_THEME = "usedarktheme";
    public static String ARG_USE_LIGHT_THEME = "uselighttheme";
    protected final Context mContext;
    protected final FragmentManager mFragmentManager;
    protected final Class<? extends BaseDialogFragment> mClass;
    private Fragment mTargetFragment;
    private boolean mCancelable = true;
    private boolean mCancelableOnTouchOutside = true;
    private boolean mUseDarkTheme = false;
    private boolean mUseLightTheme = false;

    public BaseDialogBuilder(Context context, FragmentManager fragmentManager, Class<? extends BaseDialogFragment> clazz) {
        this.mFragmentManager = fragmentManager;
        this.mContext = context.getApplicationContext();
        this.mClass = clazz;
    }

    protected abstract T self();

    protected abstract Bundle prepareArguments();

    public T setCancelable(boolean cancelable) {
        this.mCancelable = cancelable;
        return this.self();
    }

    public T setCancelableOnTouchOutside(boolean cancelable) {
        this.mCancelableOnTouchOutside = cancelable;
        if (cancelable) {
            this.mCancelable = cancelable;
        }
        return this.self();
    }

    public T setTargetFragment(Fragment fragment, int requestCode) {
        this.mTargetFragment = fragment;
        this.mRequestCode = requestCode;
        return this.self();
    }

    public T setRequestCode(int requestCode) {
        this.mRequestCode = requestCode;
        return this.self();
    }

    public T setTag(String tag) {
        this.mTag = tag;
        return this.self();
    }

    public T useDarkTheme() {
        this.mUseDarkTheme = true;
        return this.self();
    }

    public T useLightTheme() {
        this.mUseLightTheme = true;
        return this.self();
    }

    private BaseDialogFragment create() {
        Bundle args = this.prepareArguments();
        BaseDialogFragment fragment = (BaseDialogFragment)Fragment.instantiate((Context)this.mContext, (String)this.mClass.getName(), (Bundle)args);
        args.putBoolean(ARG_CANCELABLE_ON_TOUCH_OUTSIDE, this.mCancelableOnTouchOutside);
        args.putBoolean(ARG_USE_DARK_THEME, this.mUseDarkTheme);
        args.putBoolean(ARG_USE_LIGHT_THEME, this.mUseLightTheme);
        if (this.mTargetFragment != null) {
            fragment.setTargetFragment(this.mTargetFragment, this.mRequestCode);
        } else {
            args.putInt(ARG_REQUEST_CODE, this.mRequestCode);
        }
        fragment.setCancelable(this.mCancelable);
        return fragment;
    }

    public DialogFragment show() {
        BaseDialogFragment fragment = this.create();
        fragment.show(this.mFragmentManager, this.mTag);
        return fragment;
    }

    public DialogFragment showAllowingStateLoss() {
        BaseDialogFragment fragment = this.create();
        fragment.showAllowingStateLoss(this.mFragmentManager, this.mTag);
        return fragment;
    }
}

