/*
 * Decompiled with CFR 0.152.
 */
package com.avast.android.dialogs.core;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.TextView;
import com.avast.android.dialogs.R;

public abstract class BaseDialogFragment
extends DialogFragment
implements DialogInterface.OnShowListener {
    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = new Dialog((Context)this.getActivity(), R.style.SDL_Dialog);
        Bundle args = this.getArguments();
        if (args != null) {
            dialog.setCanceledOnTouchOutside(args.getBoolean("cancelable_oto"));
        }
        dialog.setOnShowListener((DialogInterface.OnShowListener)this);
        return dialog;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Builder builder = new Builder((Context)this.getActivity(), inflater, container);
        return this.build(builder).create();
    }

    protected abstract Builder build(Builder var1);

    public void onDestroyView() {
        if (this.getDialog() != null && this.getRetainInstance()) {
            this.getDialog().setDismissMessage(null);
        }
        super.onDestroyView();
    }

    public void showAllowingStateLoss(FragmentManager manager, String tag) {
        FragmentTransaction ft = manager.beginTransaction();
        ft.add((Fragment)this, tag);
        ft.commitAllowingStateLoss();
    }

    public void onShow(DialogInterface dialog) {
        if (this.getView() != null) {
            ScrollView vScrollView = (ScrollView)this.getView().findViewById(R.id.sdl_scrollview);
            boolean scrollable = this.isScrollable(vScrollView);
            this.modifyButtonsBasedOnScrollableContent(scrollable);
        }
    }

    private void modifyButtonsBasedOnScrollableContent(boolean scrollable) {
        if (this.getView() == null) {
            return;
        }
        View vButtonDivider = this.getView().findViewById(R.id.sdl_button_divider);
        View vButtonsBottomSpace = this.getView().findViewById(R.id.sdl_buttons_bottom_space);
        View vDefaultButtons = this.getView().findViewById(R.id.sdl_buttons_default);
        View vStackedButtons = this.getView().findViewById(R.id.sdl_buttons_stacked);
        if (vDefaultButtons.getVisibility() == 8 && vStackedButtons.getVisibility() == 8) {
            vButtonDivider.setVisibility(8);
            vButtonsBottomSpace.setVisibility(8);
        } else if (scrollable) {
            vButtonDivider.setVisibility(0);
            vButtonsBottomSpace.setVisibility(8);
        } else {
            vButtonDivider.setVisibility(8);
            vButtonsBottomSpace.setVisibility(0);
        }
    }

    boolean isScrollable(ScrollView scrollView) {
        if (scrollView.getChildCount() == 0) {
            return false;
        }
        int childHeight = scrollView.getChildAt(0).getMeasuredHeight();
        return scrollView.getMeasuredHeight() < childHeight;
    }

    protected static class Builder {
        private final Context mContext;
        private final ViewGroup mContainer;
        private final LayoutInflater mInflater;
        private CharSequence mTitle = null;
        private CharSequence mPositiveButtonText;
        private View.OnClickListener mPositiveButtonListener;
        private CharSequence mNegativeButtonText;
        private View.OnClickListener mNegativeButtonListener;
        private CharSequence mNeutralButtonText;
        private View.OnClickListener mNeutralButtonListener;
        private CharSequence mMessage;
        private View mCustomView;
        private ListAdapter mListAdapter;
        private int mListCheckedItemIdx;
        private AdapterView.OnItemClickListener mOnItemClickListener;

        public Builder(Context context, LayoutInflater inflater, ViewGroup container) {
            this.mContext = context;
            this.mContainer = container;
            this.mInflater = inflater;
        }

        public LayoutInflater getLayoutInflater() {
            return this.mInflater;
        }

        public Builder setTitle(int titleId) {
            this.mTitle = this.mContext.getText(titleId);
            return this;
        }

        public Builder setTitle(CharSequence title) {
            this.mTitle = title;
            return this;
        }

        public Builder setPositiveButton(int textId, View.OnClickListener listener) {
            this.mPositiveButtonText = this.mContext.getText(textId);
            this.mPositiveButtonListener = listener;
            return this;
        }

        public Builder setPositiveButton(CharSequence text, View.OnClickListener listener) {
            this.mPositiveButtonText = text;
            this.mPositiveButtonListener = listener;
            return this;
        }

        public Builder setNegativeButton(int textId, View.OnClickListener listener) {
            this.mNegativeButtonText = this.mContext.getText(textId);
            this.mNegativeButtonListener = listener;
            return this;
        }

        public Builder setNegativeButton(CharSequence text, View.OnClickListener listener) {
            this.mNegativeButtonText = text;
            this.mNegativeButtonListener = listener;
            return this;
        }

        public Builder setNeutralButton(int textId, View.OnClickListener listener) {
            this.mNeutralButtonText = this.mContext.getText(textId);
            this.mNeutralButtonListener = listener;
            return this;
        }

        public Builder setNeutralButton(CharSequence text, View.OnClickListener listener) {
            this.mNeutralButtonText = text;
            this.mNeutralButtonListener = listener;
            return this;
        }

        public Builder setMessage(int messageId) {
            this.mMessage = this.mContext.getText(messageId);
            return this;
        }

        public Builder setMessage(CharSequence message) {
            this.mMessage = message;
            return this;
        }

        public Builder setItems(ListAdapter listAdapter, int checkedItemIdx, AdapterView.OnItemClickListener listener) {
            this.mListAdapter = listAdapter;
            this.mOnItemClickListener = listener;
            this.mListCheckedItemIdx = checkedItemIdx;
            return this;
        }

        public Builder setView(View view) {
            this.mCustomView = view;
            return this;
        }

        public View create() {
            LinearLayout content = (LinearLayout)this.mInflater.inflate(R.layout.sdl_dialog, this.mContainer, false);
            TextView vTitle = (TextView)content.findViewById(R.id.sdl_title);
            TextView vMessage = (TextView)content.findViewById(R.id.sdl_message);
            FrameLayout vCustomView = (FrameLayout)content.findViewById(R.id.sdl_custom);
            Button vPositiveButton = (Button)content.findViewById(R.id.sdl_button_positive);
            Button vNegativeButton = (Button)content.findViewById(R.id.sdl_button_negative);
            Button vNeutralButton = (Button)content.findViewById(R.id.sdl_button_neutral);
            Button vPositiveButtonStacked = (Button)content.findViewById(R.id.sdl_button_positive_stacked);
            Button vNegativeButtonStacked = (Button)content.findViewById(R.id.sdl_button_negative_stacked);
            Button vNeutralButtonStacked = (Button)content.findViewById(R.id.sdl_button_neutral_stacked);
            View vButtonsDefault = content.findViewById(R.id.sdl_buttons_default);
            View vButtonsStacked = content.findViewById(R.id.sdl_buttons_stacked);
            ListView vList = (ListView)content.findViewById(R.id.sdl_list);
            this.set(vTitle, this.mTitle);
            this.set(vMessage, this.mMessage);
            this.setPaddingOfTitleAndMessage(vTitle, vMessage);
            if (this.mCustomView != null) {
                vCustomView.addView(this.mCustomView);
            }
            if (this.mListAdapter != null) {
                vList.setAdapter(this.mListAdapter);
                vList.setOnItemClickListener(this.mOnItemClickListener);
                if (this.mListCheckedItemIdx != -1) {
                    vList.setSelection(this.mListCheckedItemIdx);
                }
            }
            if (this.shouldStackButtons()) {
                this.set(vPositiveButtonStacked, this.mPositiveButtonText, this.mPositiveButtonListener);
                this.set(vNegativeButtonStacked, this.mNegativeButtonText, this.mNegativeButtonListener);
                this.set(vNeutralButtonStacked, this.mNeutralButtonText, this.mNeutralButtonListener);
                vButtonsDefault.setVisibility(8);
                vButtonsStacked.setVisibility(0);
            } else {
                this.set(vPositiveButton, this.mPositiveButtonText, this.mPositiveButtonListener);
                this.set(vNegativeButton, this.mNegativeButtonText, this.mNegativeButtonListener);
                this.set(vNeutralButton, this.mNeutralButtonText, this.mNeutralButtonListener);
                vButtonsDefault.setVisibility(0);
                vButtonsStacked.setVisibility(8);
            }
            if (TextUtils.isEmpty((CharSequence)this.mPositiveButtonText) && TextUtils.isEmpty((CharSequence)this.mNegativeButtonText) && TextUtils.isEmpty((CharSequence)this.mNeutralButtonText)) {
                vButtonsDefault.setVisibility(8);
            }
            return content;
        }

        private void setPaddingOfTitleAndMessage(TextView vTitle, TextView vMessage) {
            int grid6 = this.mContext.getResources().getDimensionPixelSize(R.dimen.grid_6);
            int grid4 = this.mContext.getResources().getDimensionPixelSize(R.dimen.grid_4);
            if (!TextUtils.isEmpty((CharSequence)this.mTitle) && !TextUtils.isEmpty((CharSequence)this.mMessage)) {
                vTitle.setPadding(grid6, grid6, grid6, grid4);
                vMessage.setPadding(grid6, 0, grid6, grid4);
            } else if (TextUtils.isEmpty((CharSequence)this.mTitle)) {
                vMessage.setPadding(grid6, grid4, grid6, grid4);
            } else if (TextUtils.isEmpty((CharSequence)this.mMessage)) {
                vTitle.setPadding(grid6, grid6, grid6, grid4);
            }
        }

        private boolean shouldStackButtons() {
            return this.shouldStackButton(this.mPositiveButtonText) || this.shouldStackButton(this.mNegativeButtonText) || this.shouldStackButton(this.mNeutralButtonText);
        }

        private boolean shouldStackButton(CharSequence text) {
            int MAX_BUTTON_CHARS = 12;
            return text != null && text.length() > 12;
        }

        private void set(Button button, CharSequence text, View.OnClickListener listener) {
            this.set((TextView)button, text);
            if (listener != null) {
                button.setOnClickListener(listener);
            }
        }

        private void set(TextView textView, CharSequence text) {
            if (text != null) {
                textView.setText(text);
            } else {
                textView.setVisibility(8);
            }
        }
    }
}

