/*
 * ACI Services API
 * API for methods pertaining to all ACI services
 *
 * OpenAPI spec version: 3.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.autocheckinsurance.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * the information for a vehicle
 */
@ApiModel(description = "the information for a vehicle")

public class VehicleInformation {
  @SerializedName("body")
  private String body = null;

  @SerializedName("country")
  private String country = null;

  @SerializedName("engine")
  private String engine = null;

  @SerializedName("manufacturer")
  private String manufacturer = null;

  @SerializedName("manufacturerCode")
  private String manufacturerCode = null;

  @SerializedName("model")
  private String model = null;

  @SerializedName("resultCode")
  private Integer resultCode = null;

  @SerializedName("resultMessage")
  private String resultMessage = null;

  @SerializedName("seriesCode")
  private String seriesCode = null;

  @SerializedName("vehicleClass")
  private String vehicleClass = null;

  @SerializedName("vin")
  private String vin = null;

  @SerializedName("year")
  private String year = null;

  public VehicleInformation body(String body) {
    this.body = body;
    return this;
  }

   /**
   * the body type
   * @return body
  **/
  @ApiModelProperty(value = "the body type")
  public String getBody() {
    return body;
  }

  public void setBody(String body) {
    this.body = body;
  }

  public VehicleInformation country(String country) {
    this.country = country;
    return this;
  }

   /**
   * the country of origin
   * @return country
  **/
  @ApiModelProperty(value = "the country of origin")
  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public VehicleInformation engine(String engine) {
    this.engine = engine;
    return this;
  }

   /**
   * the engine type/size
   * @return engine
  **/
  @ApiModelProperty(value = "the engine type/size")
  public String getEngine() {
    return engine;
  }

  public void setEngine(String engine) {
    this.engine = engine;
  }

  public VehicleInformation manufacturer(String manufacturer) {
    this.manufacturer = manufacturer;
    return this;
  }

   /**
   * the vehicle manufacturer
   * @return manufacturer
  **/
  @ApiModelProperty(value = "the vehicle manufacturer")
  public String getManufacturer() {
    return manufacturer;
  }

  public void setManufacturer(String manufacturer) {
    this.manufacturer = manufacturer;
  }

  public VehicleInformation manufacturerCode(String manufacturerCode) {
    this.manufacturerCode = manufacturerCode;
    return this;
  }

   /**
   * the vehicle manufacturer code
   * @return manufacturerCode
  **/
  @ApiModelProperty(value = "the vehicle manufacturer code")
  public String getManufacturerCode() {
    return manufacturerCode;
  }

  public void setManufacturerCode(String manufacturerCode) {
    this.manufacturerCode = manufacturerCode;
  }

  public VehicleInformation model(String model) {
    this.model = model;
    return this;
  }

   /**
   * the vehicle model
   * @return model
  **/
  @ApiModelProperty(value = "the vehicle model")
  public String getModel() {
    return model;
  }

  public void setModel(String model) {
    this.model = model;
  }

  public VehicleInformation resultCode(Integer resultCode) {
    this.resultCode = resultCode;
    return this;
  }

   /**
   * the result code (0 &#x3D; no errors)
   * @return resultCode
  **/
  @ApiModelProperty(value = "the result code (0 = no errors)")
  public Integer getResultCode() {
    return resultCode;
  }

  public void setResultCode(Integer resultCode) {
    this.resultCode = resultCode;
  }

  public VehicleInformation resultMessage(String resultMessage) {
    this.resultMessage = resultMessage;
    return this;
  }

   /**
   * the result message. Possible values include:  &#39;No error.&#39;, &#39;Invalid check-digit: The VIN contains an invalid year for the make and model.&#39;, &#39;Invalid check-digit:&#39;, &#39;Warning the VIN pattern is unknown. * Invalid check-digit: The VIN is greater than 17 characters in length.&#39;, &#39;Invalid check-digit: The VIN is less than 17 characters in length.&#39;
   * @return resultMessage
  **/
  @ApiModelProperty(value = "the result message. Possible values include:  'No error.', 'Invalid check-digit: The VIN contains an invalid year for the make and model.', 'Invalid check-digit:', 'Warning the VIN pattern is unknown. * Invalid check-digit: The VIN is greater than 17 characters in length.', 'Invalid check-digit: The VIN is less than 17 characters in length.'")
  public String getResultMessage() {
    return resultMessage;
  }

  public void setResultMessage(String resultMessage) {
    this.resultMessage = resultMessage;
  }

  public VehicleInformation seriesCode(String seriesCode) {
    this.seriesCode = seriesCode;
    return this;
  }

   /**
   * the series code
   * @return seriesCode
  **/
  @ApiModelProperty(value = "the series code")
  public String getSeriesCode() {
    return seriesCode;
  }

  public void setSeriesCode(String seriesCode) {
    this.seriesCode = seriesCode;
  }

  public VehicleInformation vehicleClass(String vehicleClass) {
    this.vehicleClass = vehicleClass;
    return this;
  }

   /**
   * the vehicle class
   * @return vehicleClass
  **/
  @ApiModelProperty(value = "the vehicle class")
  public String getVehicleClass() {
    return vehicleClass;
  }

  public void setVehicleClass(String vehicleClass) {
    this.vehicleClass = vehicleClass;
  }

  public VehicleInformation vin(String vin) {
    this.vin = vin;
    return this;
  }

   /**
   * the Vehicle Identification Number
   * @return vin
  **/
  @ApiModelProperty(value = "the Vehicle Identification Number")
  public String getVin() {
    return vin;
  }

  public void setVin(String vin) {
    this.vin = vin;
  }

  public VehicleInformation year(String year) {
    this.year = year;
    return this;
  }

   /**
   * the model year
   * @return year
  **/
  @ApiModelProperty(value = "the model year")
  public String getYear() {
    return year;
  }

  public void setYear(String year) {
    this.year = year;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VehicleInformation vehicleInformation = (VehicleInformation) o;
    return Objects.equals(this.body, vehicleInformation.body) &&
        Objects.equals(this.country, vehicleInformation.country) &&
        Objects.equals(this.engine, vehicleInformation.engine) &&
        Objects.equals(this.manufacturer, vehicleInformation.manufacturer) &&
        Objects.equals(this.manufacturerCode, vehicleInformation.manufacturerCode) &&
        Objects.equals(this.model, vehicleInformation.model) &&
        Objects.equals(this.resultCode, vehicleInformation.resultCode) &&
        Objects.equals(this.resultMessage, vehicleInformation.resultMessage) &&
        Objects.equals(this.seriesCode, vehicleInformation.seriesCode) &&
        Objects.equals(this.vehicleClass, vehicleInformation.vehicleClass) &&
        Objects.equals(this.vin, vehicleInformation.vin) &&
        Objects.equals(this.year, vehicleInformation.year);
  }

  @Override
  public int hashCode() {
    return Objects.hash(body, country, engine, manufacturer, manufacturerCode, model, resultCode, resultMessage, seriesCode, vehicleClass, vin, year);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VehicleInformation {\n");
    
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    engine: ").append(toIndentedString(engine)).append("\n");
    sb.append("    manufacturer: ").append(toIndentedString(manufacturer)).append("\n");
    sb.append("    manufacturerCode: ").append(toIndentedString(manufacturerCode)).append("\n");
    sb.append("    model: ").append(toIndentedString(model)).append("\n");
    sb.append("    resultCode: ").append(toIndentedString(resultCode)).append("\n");
    sb.append("    resultMessage: ").append(toIndentedString(resultMessage)).append("\n");
    sb.append("    seriesCode: ").append(toIndentedString(seriesCode)).append("\n");
    sb.append("    vehicleClass: ").append(toIndentedString(vehicleClass)).append("\n");
    sb.append("    vin: ").append(toIndentedString(vin)).append("\n");
    sb.append("    year: ").append(toIndentedString(year)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

