/*
 * Decompiled with CFR 0.152.
 */
package com.autocheckinsurance.sdk.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;

public class VehicleRiskResult {
    @SerializedName(value="effectiveEndDate")
    private LocalDate effectiveEndDate = null;
    @SerializedName(value="referenceNumber")
    private String referenceNumber = null;
    @SerializedName(value="results")
    private String results = null;
    @SerializedName(value="vin")
    private String vin = null;

    public VehicleRiskResult effectiveEndDate(LocalDate effectiveEndDate) {
        this.effectiveEndDate = effectiveEndDate;
        return this;
    }

    @ApiModelProperty(value="the effective end date")
    public LocalDate getEffectiveEndDate() {
        return this.effectiveEndDate;
    }

    public void setEffectiveEndDate(LocalDate effectiveEndDate) {
        this.effectiveEndDate = effectiveEndDate;
    }

    public VehicleRiskResult referenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
        return this;
    }

    @ApiModelProperty(value="the reference number for the caller's tracking purposes")
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public VehicleRiskResult results(String results) {
        this.results = results;
        return this;
    }

    @ApiModelProperty(value="The risk prediction results. Possible values include:  An integer between 20 and 999.', 'Invalid Date', 'Invalid Type', 'Invalid check-digit: The VIN contains an invalid year for the make and model.', 'Invalid check-digit:', 'Warning the VIN pattern is unknown. * Invalid check-digit: The VIN is greater than 17 characters in length.', 'Invalid check-digit: The VIN is less than 17 characters in length.'")
    public String getResults() {
        return this.results;
    }

    public void setResults(String results) {
        this.results = results;
    }

    public VehicleRiskResult vin(String vin) {
        this.vin = vin;
        return this;
    }

    @ApiModelProperty(value="the vehicle identification number")
    public String getVin() {
        return this.vin;
    }

    public void setVin(String vin) {
        this.vin = vin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleRiskResult vehicleRiskResult = (VehicleRiskResult)o;
        return Objects.equals(this.effectiveEndDate, vehicleRiskResult.effectiveEndDate) && Objects.equals(this.referenceNumber, vehicleRiskResult.referenceNumber) && Objects.equals(this.results, vehicleRiskResult.results) && Objects.equals(this.vin, vehicleRiskResult.vin);
    }

    public int hashCode() {
        return Objects.hash(this.effectiveEndDate, this.referenceNumber, this.results, this.vin);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VehicleRiskResult {\n");
        sb.append("    effectiveEndDate: ").append(this.toIndentedString(this.effectiveEndDate)).append("\n");
        sb.append("    referenceNumber: ").append(this.toIndentedString(this.referenceNumber)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("    vin: ").append(this.toIndentedString(this.vin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

