/*
 * Decompiled with CFR 0.152.
 */
package com.autocheckinsurance.sdk.api;

import com.autocheckinsurance.sdk.ApiCallback;
import com.autocheckinsurance.sdk.ApiClient;
import com.autocheckinsurance.sdk.ApiException;
import com.autocheckinsurance.sdk.ApiResponse;
import com.autocheckinsurance.sdk.Configuration;
import com.autocheckinsurance.sdk.Pair;
import com.autocheckinsurance.sdk.ProgressRequestBody;
import com.autocheckinsurance.sdk.ProgressResponseBody;
import com.autocheckinsurance.sdk.model.RiskCalculationPlusResponse;
import com.autocheckinsurance.sdk.model.RiskCalculationRequest;
import com.autocheckinsurance.sdk.model.RiskCalculationResponse;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class VehicleApi {
    private ApiClient apiClient;

    public VehicleApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VehicleApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call calcRiskCall(String xApiKey, String xAutotecId, RiskCalculationRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RiskCalculationRequest localVarPostBody = request;
        String localVarPath = "/vehicle/risk";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        if (xAutotecId != null) {
            localVarHeaderParams.put("x-autotec-id", this.apiClient.parameterToString(xAutotecId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"CustomerAuthorizer", "api_key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call calcRiskValidateBeforeCall(String xApiKey, String xAutotecId, RiskCalculationRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xApiKey == null) {
            throw new ApiException("Missing the required parameter 'xApiKey' when calling calcRisk(Async)");
        }
        if (xAutotecId == null) {
            throw new ApiException("Missing the required parameter 'xAutotecId' when calling calcRisk(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling calcRisk(Async)");
        }
        Call call = this.calcRiskCall(xApiKey, xAutotecId, request, progressListener, progressRequestListener);
        return call;
    }

    public RiskCalculationResponse calcRisk(String xApiKey, String xAutotecId, RiskCalculationRequest request) throws ApiException {
        ApiResponse<RiskCalculationResponse> resp = this.calcRiskWithHttpInfo(xApiKey, xAutotecId, request);
        return resp.getData();
    }

    public ApiResponse<RiskCalculationResponse> calcRiskWithHttpInfo(String xApiKey, String xAutotecId, RiskCalculationRequest request) throws ApiException {
        Call call = this.calcRiskValidateBeforeCall(xApiKey, xAutotecId, request, null, null);
        Type localVarReturnType = new TypeToken<RiskCalculationResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call calcRiskAsync(String xApiKey, String xAutotecId, RiskCalculationRequest request, final ApiCallback<RiskCalculationResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.calcRiskValidateBeforeCall(xApiKey, xAutotecId, request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RiskCalculationResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call calcRiskPlusCall(String xApiKey, String xAutotecId, RiskCalculationRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RiskCalculationRequest localVarPostBody = request;
        String localVarPath = "/vehicle/risk/plus";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        if (xAutotecId != null) {
            localVarHeaderParams.put("x-autotec-id", this.apiClient.parameterToString(xAutotecId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"CustomerAuthorizer", "api_key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call calcRiskPlusValidateBeforeCall(String xApiKey, String xAutotecId, RiskCalculationRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xApiKey == null) {
            throw new ApiException("Missing the required parameter 'xApiKey' when calling calcRiskPlus(Async)");
        }
        if (xAutotecId == null) {
            throw new ApiException("Missing the required parameter 'xAutotecId' when calling calcRiskPlus(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling calcRiskPlus(Async)");
        }
        Call call = this.calcRiskPlusCall(xApiKey, xAutotecId, request, progressListener, progressRequestListener);
        return call;
    }

    public RiskCalculationPlusResponse calcRiskPlus(String xApiKey, String xAutotecId, RiskCalculationRequest request) throws ApiException {
        ApiResponse<RiskCalculationPlusResponse> resp = this.calcRiskPlusWithHttpInfo(xApiKey, xAutotecId, request);
        return resp.getData();
    }

    public ApiResponse<RiskCalculationPlusResponse> calcRiskPlusWithHttpInfo(String xApiKey, String xAutotecId, RiskCalculationRequest request) throws ApiException {
        Call call = this.calcRiskPlusValidateBeforeCall(xApiKey, xAutotecId, request, null, null);
        Type localVarReturnType = new TypeToken<RiskCalculationPlusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call calcRiskPlusAsync(String xApiKey, String xAutotecId, RiskCalculationRequest request, final ApiCallback<RiskCalculationPlusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.calcRiskPlusValidateBeforeCall(xApiKey, xAutotecId, request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RiskCalculationPlusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

