/*
 * AutoCheck Insurance Services API
 * API for methods pertaining to all AutoCheck Insurance services
 *
 * OpenAPI spec version: 2.0.11
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.autocheckinsurance.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * VehicleRequestAttribute
 */

public class VehicleRequestAttribute {
  @SerializedName("dealerNumber")
  private String dealerNumber = null;

  @SerializedName("referenceNumber")
  private String referenceNumber = null;

  @SerializedName("saleNumber")
  private String saleNumber = null;

  @SerializedName("vin")
  private String vin = null;

  public VehicleRequestAttribute dealerNumber(String dealerNumber) {
    this.dealerNumber = dealerNumber;
    return this;
  }

   /**
   * the dealer number assigned by the auction
   * @return dealerNumber
  **/
  @ApiModelProperty(value = "the dealer number assigned by the auction")
  public String getDealerNumber() {
    return dealerNumber;
  }

  public void setDealerNumber(String dealerNumber) {
    this.dealerNumber = dealerNumber;
  }

  public VehicleRequestAttribute referenceNumber(String referenceNumber) {
    this.referenceNumber = referenceNumber;
    return this;
  }

   /**
   * the reference number for the caller&#39;s tracking purposes
   * @return referenceNumber
  **/
  @ApiModelProperty(value = "the reference number for the caller's tracking purposes")
  public String getReferenceNumber() {
    return referenceNumber;
  }

  public void setReferenceNumber(String referenceNumber) {
    this.referenceNumber = referenceNumber;
  }

  public VehicleRequestAttribute saleNumber(String saleNumber) {
    this.saleNumber = saleNumber;
    return this;
  }

   /**
   * the lane assignment and run number assigned to the vehicle from the auction
   * @return saleNumber
  **/
  @ApiModelProperty(value = "the lane assignment and run number assigned to the vehicle from the auction")
  public String getSaleNumber() {
    return saleNumber;
  }

  public void setSaleNumber(String saleNumber) {
    this.saleNumber = saleNumber;
  }

  public VehicleRequestAttribute vin(String vin) {
    this.vin = vin;
    return this;
  }

   /**
   * the vehicle identification number
   * @return vin
  **/
  @ApiModelProperty(required = true, value = "the vehicle identification number")
  public String getVin() {
    return vin;
  }

  public void setVin(String vin) {
    this.vin = vin;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VehicleRequestAttribute vehicleRequestAttribute = (VehicleRequestAttribute) o;
    return Objects.equals(this.dealerNumber, vehicleRequestAttribute.dealerNumber) &&
        Objects.equals(this.referenceNumber, vehicleRequestAttribute.referenceNumber) &&
        Objects.equals(this.saleNumber, vehicleRequestAttribute.saleNumber) &&
        Objects.equals(this.vin, vehicleRequestAttribute.vin);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dealerNumber, referenceNumber, saleNumber, vin);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VehicleRequestAttribute {\n");
    
    sb.append("    dealerNumber: ").append(toIndentedString(dealerNumber)).append("\n");
    sb.append("    referenceNumber: ").append(toIndentedString(referenceNumber)).append("\n");
    sb.append("    saleNumber: ").append(toIndentedString(saleNumber)).append("\n");
    sb.append("    vin: ").append(toIndentedString(vin)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

