/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.task;

import com.autonomousapps.internal.analysis.AbstractIssueListener;
import com.autonomousapps.internal.analysis.AllProjectsListener;
import com.autonomousapps.internal.analysis.ClassAnalyzer;
import com.autonomousapps.internal.analysis.CompositeIssueListener;
import com.autonomousapps.internal.analysis.EagerApisListener;
import com.autonomousapps.internal.analysis.GetAllprojectsListener;
import com.autonomousapps.internal.analysis.GetProjectListener;
import com.autonomousapps.internal.analysis.GetSubprojectsListener;
import com.autonomousapps.internal.analysis.IssueListener;
import com.autonomousapps.internal.analysis.SubprojectsListener;
import com.autonomousapps.internal.asm.ClassReader;
import com.autonomousapps.internal.asm.ClassVisitor;
import com.autonomousapps.internal.logging.ConfigurableLogger;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.FilesKt;
import com.autonomousapps.internal.utils.Json;
import com.autonomousapps.issue.Issue;
import com.autonomousapps.task.CheckBestPracticesTask;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001c\u001a\u00020\u001dH\u0007R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011R\u0014\u0010\u0015\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u0014\u0010\u0017\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\bR\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/autonomousapps/task/CheckBestPracticesTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "baseline", "Lorg/gradle/api/file/RegularFileProperty;", "getBaseline", "()Lorg/gradle/api/file/RegularFileProperty;", "classesDirs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClassesDirs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "creatingBaseline", "Lorg/gradle/api/provider/Property;", "", "getCreatingBaseline", "()Lorg/gradle/api/provider/Property;", "logLevel", "Lcom/autonomousapps/internal/logging/ConfigurableLogger$Level;", "getLogLevel", "outputJson", "getOutputJson", "outputText", "getOutputText", "projectPath", "", "getProjectPath", "action", "", "Action", "Parameters", "plugin-best-practices-plugin"})
public abstract class CheckBestPracticesTask
extends DefaultTask {
    @NotNull
    private final WorkerExecutor workerExecutor;

    @Inject
    public CheckBestPracticesTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
        this.setGroup("verification");
        this.setDescription("Checks for violations of Gradle plugin best practices");
    }

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getClassesDirs();

    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getBaseline();

    @Input
    @NotNull
    public abstract Property<Boolean> getCreatingBaseline();

    @Input
    @NotNull
    public abstract Property<String> getProjectPath();

    @Input
    @NotNull
    public abstract Property<ConfigurableLogger.Level> getLogLevel();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputJson();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputText();

    @TaskAction
    public final void action() {
        this.workerExecutor.noIsolation().submit(Action.class, arg_0 -> CheckBestPracticesTask.action$lambda$0((Function1)new Function1<Parameters, Unit>(this){
            final /* synthetic */ CheckBestPracticesTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Parameters it) {
                it.getClassesDirs().setFrom((Iterable)this.this$0.getClassesDirs());
                it.getBaseline().set((Provider)this.this$0.getBaseline());
                it.getCreatingBaseline().set((Provider)this.this$0.getCreatingBaseline());
                it.getProjectPath().set((Provider)this.this$0.getProjectPath());
                it.getLogLevel().set((Provider)this.this$0.getLogLevel());
                it.getOutputJson().set((Provider)this.this$0.getOutputJson());
                it.getOutputText().set((Provider)this.this$0.getOutputText());
            }
        }, arg_0));
    }

    private static final void action$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000eR\u0012\u0010\u0012\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0005R\u0012\u0010\u0014\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0005R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/autonomousapps/task/CheckBestPracticesTask$Parameters;", "Lorg/gradle/workers/WorkParameters;", "baseline", "Lorg/gradle/api/file/RegularFileProperty;", "getBaseline", "()Lorg/gradle/api/file/RegularFileProperty;", "classesDirs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClassesDirs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "creatingBaseline", "Lorg/gradle/api/provider/Property;", "", "getCreatingBaseline", "()Lorg/gradle/api/provider/Property;", "logLevel", "Lcom/autonomousapps/internal/logging/ConfigurableLogger$Level;", "getLogLevel", "outputJson", "getOutputJson", "outputText", "getOutputText", "projectPath", "", "getProjectPath", "plugin-best-practices-plugin"})
    public static interface Parameters
    extends WorkParameters {
        @NotNull
        public ConfigurableFileCollection getClassesDirs();

        @NotNull
        public RegularFileProperty getBaseline();

        @NotNull
        public Property<Boolean> getCreatingBaseline();

        @NotNull
        public Property<String> getProjectPath();

        @NotNull
        public Property<ConfigurableLogger.Level> getLogLevel();

        @NotNull
        public RegularFileProperty getOutputJson();

        @NotNull
        public RegularFileProperty getOutputText();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\f\u001a\n \r*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\t\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/autonomousapps/task/CheckBestPracticesTask$Action;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/task/CheckBestPracticesTask$Parameters;", "()V", "baselineFixText", "", "getBaselineFixText", "()Ljava/lang/String;", "baselineFixText$delegate", "Lkotlin/Lazy;", "logger", "Lcom/autonomousapps/internal/logging/ConfigurableLogger;", "projectPath", "kotlin.jvm.PlatformType", "getProjectPath", "projectPath$delegate", "compositeListener", "Lcom/autonomousapps/internal/analysis/IssueListener;", "execute", "", "plugin-best-practices-plugin"})
    public static abstract class Action
    implements WorkAction<Parameters> {
        @NotNull
        private final ConfigurableLogger logger;
        @NotNull
        private final Lazy projectPath$delegate;
        @NotNull
        private final Lazy baselineFixText$delegate;

        public Action() {
            Logger $this$logger_u24lambda_u240 = Logging.getLogger((String)CheckBestPracticesTask.class.getSimpleName());
            Action action2 = this;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$logger_u24lambda_u240, (String)"this");
            Object object = ((Parameters)this.getParameters()).getLogLevel().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.logLevel.get()");
            action2.logger = new ConfigurableLogger($this$logger_u24lambda_u240, (ConfigurableLogger.Level)((Object)object));
            this.projectPath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ Action this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final String invoke() {
                    String path = (String)((Parameters)this.this$0.getParameters()).getProjectPath().get();
                    return Intrinsics.areEqual((Object)path, (Object)":") ? "" : path;
                }
            }));
            this.baselineFixText$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ Action this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "`./gradlew " + Action.access$getProjectPath(this.this$0) + ":bestPracticesBaseline`";
                }
            }));
        }

        private final String getProjectPath() {
            Lazy lazy = this.projectPath$delegate;
            return (String)lazy.getValue();
        }

        private final String getBaselineFixText() {
            Lazy lazy = this.baselineFixText$delegate;
            return (String)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void execute() {
            void this_$iv;
            String string;
            List list;
            List list2;
            Iterable this_$iv$iv;
            Type[] classReader;
            Object object;
            Object classFile;
            Object element$iv2;
            File outputJson = FilesKt.getAndDelete(((Parameters)this.getParameters()).getOutputJson());
            File outputText = FilesKt.getAndDelete(((Parameters)this.getParameters()).getOutputText());
            FileTree fileTree = ((Parameters)this.getParameters()).getClassesDirs().getAsFileTree();
            Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"parameters.classesDirs.asFileTree");
            Set classFiles = CollectionsKt.filterToClassFiles((FileCollection)fileTree).getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)classFiles, (String)"classFiles");
            this.logger.debug("classFiles=" + kotlin.collections.CollectionsKt.joinToString$default((Iterable)classFiles, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)57, null));
            IssueListener issueListener = this.compositeListener();
            Iterable $this$forEach$iv = classFiles;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                classFile = (File)element$iv2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)classFile, (String)"classFile");
                object = new FileInputStream((File)classFile);
                Throwable throwable = null;
                try {
                    ClassAnalyzer classAnalyzer;
                    FileInputStream fis = (FileInputStream)object;
                    boolean bl2 = false;
                    classReader = new ClassReader(ByteStreamsKt.readBytes((InputStream)fis));
                    boolean bl3 = false;
                    ClassAnalyzer $this$execute_u24lambda_u244_u24lambda_u243_u24lambda_u242_u24lambda_u241 = classAnalyzer = new ClassAnalyzer(issueListener, this.logger);
                    boolean bl4 = false;
                    classReader.accept((ClassVisitor)$this$execute_u24lambda_u244_u24lambda_u243_u24lambda_u242_u24lambda_u241, 0);
                    fis = Unit.INSTANCE;
                }
                catch (Throwable fis) {
                    throwable = fis;
                    throw fis;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            Iterable $this$sortedBy$iv = issueListener.computeIssues();
            boolean $i$f$sortedBy22 = false;
            List issues = kotlin.collections.CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Issue it = (Issue)a;
                    boolean bl = false;
                    String string = it.getClass().getCanonicalName();
                    if (string == null) {
                        string = it.getClass().getSimpleName();
                    }
                    it = (Issue)b;
                    Comparable comparable = (Comparable)((Object)string);
                    bl = false;
                    String string2 = it.getClass().getCanonicalName();
                    if (string2 == null) {
                        string2 = it.getClass().getSimpleName();
                    }
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string2)));
                }
            });
            RegularFile $i$f$sortedBy22 = (RegularFile)((Parameters)this.getParameters()).getBaseline().getOrNull();
            if ($i$f$sortedBy22 != null && (element$iv2 = $i$f$sortedBy22.getAsFile()) != null && (classFile = kotlin.io.FilesKt.readText$default(element$iv2, null, (int)1, null)) != null) {
                void this_$iv2;
                Json bl = Json.INSTANCE;
                Object $this$fromJsonList$iv = classFile;
                boolean $i$f$fromJsonList = false;
                this_$iv$iv = this_$iv2;
                boolean $i$f$getJsonListAdapter = false;
                classReader = new Type[]{(Type)((Object)Issue.class)};
                ParameterizedType type$iv$iv = Types.newParameterizedType((Type)((Type)((Object)List.class)), (Type[])classReader);
                JsonAdapter jsonAdapter = Json.access$getMOSHI((Json)((Object)this_$iv$iv)).adapter((Type)type$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(type)");
                Object object2 = jsonAdapter.fromJson((String)$this$fromJsonList$iv);
                Intrinsics.checkNotNull((Object)object2);
                list2 = (List)object2;
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = kotlin.collections.CollectionsKt.emptyList();
            }
            List baseline = list;
            boolean hasNewIssues = false;
            boolean hasFixedIssues = false;
            if (baseline.isEmpty()) {
                string = kotlin.collections.CollectionsKt.joinToString$default((Iterable)issues, (CharSequence)"\n\n", null, null, (int)0, null, (Function1)execute.text.1.INSTANCE, (int)30, null);
            } else {
                void $this$filterTo$iv$iv;
                void $this$filterTo$iv$iv2;
                void $this$filterTo$iv$iv3;
                Iterable $this$filter$iv = issues;
                boolean $i$f$filter = false;
                this_$iv$iv = $this$filter$iv;
                Iterable destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                    Issue it = (Issue)element$iv$iv;
                    boolean bl = false;
                    if (!(!baseline.contains(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List newIssues = (List)destination$iv$iv;
                Iterable $this$filter$iv2 = baseline;
                boolean $i$f$filter2 = false;
                destination$iv$iv = $this$filter$iv2;
                Iterable destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    Issue it = (Issue)element$iv$iv;
                    boolean bl = false;
                    if (!(!issues.contains(it))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List fixedIssues = (List)destination$iv$iv2;
                Object $this$filter$iv3 = baseline;
                boolean $i$f$filter3 = false;
                destination$iv$iv2 = $this$filter$iv3;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Issue it = (Issue)element$iv$iv;
                    boolean bl = false;
                    if (!issues.contains(it)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                List unfixedIssues = (List)destination$iv$iv3;
                hasNewIssues = !((Collection)newIssues).isEmpty();
                hasFixedIssues = !((Collection)fixedIssues).isEmpty();
                Object $this$execute_u24lambda_u249 = $this$filter$iv3 = new StringBuilder();
                boolean bl = false;
                if (!((Collection)newIssues).isEmpty()) {
                    StringBuilder stringBuilder = ((StringBuilder)$this$execute_u24lambda_u249).append("There are new issues:");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
                    StringBuilder stringBuilder2 = ((StringBuilder)$this$execute_u24lambda_u249).append(kotlin.collections.CollectionsKt.joinToString$default((Iterable)newIssues, (CharSequence)"\n\n", null, null, (int)0, null, (Function1)execute.text.2.1.INSTANCE, (int)30, null));
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
                    Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$execute_u24lambda_u249).append('\n'), (String)"append('\\n')");
                } else {
                    StringBuilder stringBuilder = ((StringBuilder)$this$execute_u24lambda_u249).append("No new issues.");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
                    Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$execute_u24lambda_u249).append('\n'), (String)"append('\\n')");
                }
                if (!((Collection)fixedIssues).isEmpty()) {
                    StringBuilder stringBuilder = ((StringBuilder)$this$execute_u24lambda_u249).append("These issues have been resolved and should be removed from your baseline:");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
                    StringBuilder stringBuilder3 = ((StringBuilder)$this$execute_u24lambda_u249).append(kotlin.collections.CollectionsKt.joinToString$default((Iterable)fixedIssues, (CharSequence)"\n\n", null, null, (int)0, null, (Function1)execute.text.2.2.INSTANCE, (int)30, null));
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
                    Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$execute_u24lambda_u249).append('\n'), (String)"append('\\n')");
                }
                if (!((Collection)unfixedIssues).isEmpty()) {
                    StringBuilder stringBuilder = ((StringBuilder)$this$execute_u24lambda_u249).append("These issues have been ignored as part of your baseline:");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
                    StringBuilder stringBuilder4 = ((StringBuilder)$this$execute_u24lambda_u249).append(kotlin.collections.CollectionsKt.joinToString$default((Iterable)unfixedIssues, (CharSequence)"\n\n", null, null, (int)0, null, (Function1)execute.text.2.3.INSTANCE, (int)30, null));
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
                    Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$execute_u24lambda_u249).append('\n'), (String)"append('\\n')");
                }
                String string2 = ((StringBuilder)$this$filter$iv3).toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            }
            String text2 = string;
            kotlin.io.FilesKt.writeText$default((File)outputText, (String)text2, null, (int)2, null);
            Json newIssues = Json.INSTANCE;
            List $this$toJson$iv = issues;
            boolean $i$f$toJson = false;
            this_$iv$iv = this_$iv;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter jsonAdapter = Json.access$getMOSHI((Json)((Object)this_$iv$iv)).adapter(List.class);
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
            String string3 = jsonAdapter.toJson((Object)$this$toJson$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getJsonAdapter<T>().toJson(this)");
            kotlin.io.FilesKt.writeText$default((File)outputJson, (String)string3, null, (int)2, null);
            Object object3 = ((Parameters)this.getParameters()).getCreatingBaseline().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.creatingBaseline.get()");
            if (((Boolean)object3).booleanValue()) {
                return;
            }
            if (!((Collection)issues).isEmpty()) {
                this.logger.report(text2);
                if (baseline.isEmpty() || hasNewIssues) {
                    Object $this$execute_u24lambda_u2410 = object = new StringBuilder();
                    boolean bl = false;
                    StringBuilder stringBuilder = ((StringBuilder)$this$execute_u24lambda_u2410).append("Violations of best practices detected. See the report at " + outputText.getAbsolutePath() + " ");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
                    Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$execute_u24lambda_u2410).append('\n'), (String)"append('\\n')");
                    StringBuilder stringBuilder5 = ((StringBuilder)$this$execute_u24lambda_u2410).append("To create or update the baseline, run " + this.getBaselineFixText());
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
                    String string4 = ((StringBuilder)object).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
                    String errorText = string4;
                    throw new GradleException(errorText);
                }
            }
            if (hasFixedIssues) {
                throw new GradleException("Your baseline contains resolved issues. Update with " + this.getBaselineFixText());
            }
        }

        private final IssueListener compositeListener() {
            Object[] objectArray = new AbstractIssueListener[]{new AllProjectsListener(), new GetAllprojectsListener(), new SubprojectsListener(), new GetSubprojectsListener(), new GetProjectListener(), new EagerApisListener()};
            List listeners = kotlin.collections.CollectionsKt.listOf((Object[])objectArray);
            return new CompositeIssueListener(listeners);
        }

        public static final /* synthetic */ String access$getProjectPath(Action $this) {
            return $this.getProjectPath();
        }
    }
}

