/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.analysis;

import com.autonomousapps.graph.ShortestPath;
import com.autonomousapps.internal.analysis.AbstractIssueListener;
import com.autonomousapps.internal.analysis.IssueListener;
import com.autonomousapps.internal.graphs.Class;
import com.autonomousapps.internal.graphs.Method;
import com.autonomousapps.internal.graphs.MethodNode;
import com.autonomousapps.issue.Trace;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0004J\u001e\u0010\u0015\u001a\u00020\u00162\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0014J\u001e\u0010\u0019\u001a\u00020\u00162\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\u0018\u001a\u00020\tH&J \u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010\u0018\u001a\u00020\tH\u0002J(\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010\u000f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0$H\u0014J\u0010\u0010%\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u000fH\u0014J\b\u0010&\u001a\u00020!H\u0014J \u0010'\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0014J\b\u0010(\u001a\u00020!H\u0014J&\u0010)\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010\u000f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0$J\u0016\u0010*\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000fJ\u000e\u0010+\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u000fJ\u0006\u0010,\u001a\u00020!J\u001e\u0010-\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R8\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fRT\u0010\r\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000f0\u000f \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u000e0\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006."}, d2={"Lcom/autonomousapps/internal/analysis/AbstractIssueListener;", "Lcom/autonomousapps/internal/analysis/IssueListener;", "()V", "currentClass", "Lcom/autonomousapps/internal/graphs/Class;", "currentMethod", "Lcom/autonomousapps/internal/graphs/Method;", "graph", "Lcom/google/common/graph/MutableGraph;", "Lcom/autonomousapps/internal/graphs/MethodNode;", "kotlin.jvm.PlatformType", "getGraph", "()Lcom/google/common/graph/MutableGraph;", "parentPointers", "Lcom/google/common/collect/SetMultimap;", "", "getParentPointers", "()Lcom/google/common/collect/SetMultimap;", "computeTraces", "", "Lcom/autonomousapps/issue/Trace;", "isEntryPointNode", "", "Lcom/google/common/graph/Graph;", "methodNode", "isSuspectNode", "methodInstructionNode", "owner", "name", "descriptor", "methodMetadata", "Lcom/autonomousapps/internal/graphs/MethodNode$Metadata;", "onVisitClass", "", "superName", "interfaces", "", "onVisitMethodAnnotation", "onVisitMethodEnd", "onVisitMethodInstruction", "preComputeTraces", "visitClass", "visitMethod", "visitMethodAnnotation", "visitMethodEnd", "visitMethodInstruction", "plugin-best-practices-plugin"})
public abstract class AbstractIssueListener
implements IssueListener {
    private Class currentClass;
    @Nullable
    private Method currentMethod;
    private final SetMultimap<String, String> parentPointers = MultimapBuilder.hashKeys().hashSetValues().build();
    private final MutableGraph<MethodNode> graph = GraphBuilder.directed().incidentEdgeOrder(ElementOrder.stable()).allowsSelfLoops(true).build();

    protected final SetMultimap<String, String> getParentPointers() {
        return this.parentPointers;
    }

    protected final MutableGraph<MethodNode> getGraph() {
        return this.graph;
    }

    @Override
    public final void visitClass(@NotNull String name, @Nullable String superName, @NotNull List<String> interfaces) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(interfaces, (String)"interfaces");
        this.currentClass = new Class(name, superName);
        String string = superName;
        if (string != null) {
            String parent = string;
            boolean bl = false;
            this.parentPointers.put((Object)name, (Object)parent);
        }
        Iterable $this$forEach$iv = interfaces;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String parent = (String)element$iv;
            boolean bl = false;
            this.parentPointers.put((Object)name, (Object)parent);
        }
        this.onVisitClass(name, superName, interfaces);
    }

    protected void onVisitClass(@NotNull String name, @Nullable String superName, @NotNull List<String> interfaces) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(interfaces, (String)"interfaces");
    }

    @Override
    public final void visitMethod(@NotNull String name, @NotNull String descriptor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.currentMethod = new Method(name, descriptor);
    }

    @Override
    public final void visitMethodEnd() {
        this.currentMethod = null;
        this.onVisitMethodEnd();
    }

    protected void onVisitMethodEnd() {
    }

    @Override
    public final void visitMethodAnnotation(@NotNull String descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.onVisitMethodAnnotation(descriptor);
    }

    protected void onVisitMethodAnnotation(@NotNull String descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
    }

    @Override
    public final void visitMethodInstruction(@NotNull String owner, @NotNull String name, @NotNull String descriptor) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        MethodNode source = this.methodNode();
        MethodNode target = this.methodInstructionNode(owner, name, descriptor);
        this.graph.putEdge((Object)source, (Object)target);
        this.onVisitMethodInstruction(owner, name, descriptor);
    }

    protected void onVisitMethodInstruction(@NotNull String owner, @NotNull String name, @NotNull String descriptor) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Set<Trace> computeTraces() {
        void $this$flatMapTo$iv;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        this.preComputeTraces();
        Set set = this.graph.nodes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"graph.nodes()");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            MethodNode it = (MethodNode)element$iv$iv;
            boolean bl = false;
            MutableGraph<MethodNode> mutableGraph = this.graph;
            Intrinsics.checkNotNullExpressionValue(mutableGraph, (String)"graph");
            Graph graph = (Graph)mutableGraph;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!this.isSuspectNode((Graph<MethodNode>)graph, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List suspectNodes = (List)destination$iv$iv;
        if (suspectNodes.isEmpty()) {
            return SetsKt.emptySet();
        }
        Set set2 = this.graph.nodes();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"graph.nodes()");
        Iterable $this$filter$iv2 = set2;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MethodNode it = (MethodNode)element$iv$iv;
            boolean bl = false;
            MutableGraph<MethodNode> mutableGraph = this.graph;
            Intrinsics.checkNotNullExpressionValue(mutableGraph, (String)"graph");
            Graph graph = (Graph)mutableGraph;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!this.isEntryPointNode((Graph<MethodNode>)graph, it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List entryPoints = (List)destination$iv$iv2;
        if (entryPoints.isEmpty()) {
            return SetsKt.emptySet();
        }
        $this$filter$iv2 = entryPoints;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            MethodNode entryNode = (MethodNode)element$iv;
            boolean bl = false;
            MutableGraph<MethodNode> mutableGraph = this.graph;
            Intrinsics.checkNotNullExpressionValue(mutableGraph, (String)"graph");
            ShortestPath paths = new ShortestPath((Graph)mutableGraph, (Object)entryNode);
            Sequence list$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)suspectNodes), (Function1)((Function1)new Function1<MethodNode, Iterable<? extends MethodNode>>((ShortestPath<MethodNode>)paths){
                final /* synthetic */ ShortestPath<MethodNode> $paths;
                {
                    this.$paths = $paths;
                    super(1);
                }

                @NotNull
                public final Iterable<MethodNode> invoke(MethodNode it) {
                    return this.$paths.pathTo((Object)it);
                }
            })), (Function1)computeTraces.1.2.INSTANCE), (Function1)computeTraces.1.3.INSTANCE), (Function1)computeTraces.1.4.INSTANCE);
            CollectionsKt.addAll((Collection)destination$iv, (Sequence)list$iv);
        }
        return (Set)destination$iv;
    }

    protected void preComputeTraces() {
    }

    protected boolean isEntryPointNode(@NotNull Graph<MethodNode> graph, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter(graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        return graph.inDegree((Object)methodNode) == 0;
    }

    public abstract boolean isSuspectNode(@NotNull Graph<MethodNode> var1, @NotNull MethodNode var2);

    private final MethodNode methodNode() {
        Method method = this.currentMethod;
        if (method == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Method currentMethod = method;
        Class clazz = this.currentClass;
        if (clazz == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentClass");
            clazz = null;
        }
        return new MethodNode(clazz.getName(), currentMethod.getName(), currentMethod.getDescriptor(), this.methodMetadata());
    }

    private final MethodNode methodInstructionNode(String owner, String name, String descriptor) {
        return new MethodNode(owner, name, descriptor, null, 8, null);
    }

    @NotNull
    protected MethodNode.Metadata methodMetadata() {
        return MethodNode.Metadata.Companion.getEMPTY();
    }
}

