/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.extension.DependenciesHandler;
import com.autonomousapps.internal.reason.DependencyAdviceExplainer;
import com.autonomousapps.internal.reason.ModuleAdviceExplainer;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.CoordinatesString;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Advice;
import com.autonomousapps.model.AndroidScore;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.GradleVariantIdentification;
import com.autonomousapps.model.IncludedBuildCoordinates;
import com.autonomousapps.model.ProjectAdvice;
import com.autonomousapps.model.ProjectCoordinates;
import com.autonomousapps.model.internal.DependencyGraphView;
import com.autonomousapps.model.internal.intermediates.BundleTrace;
import com.autonomousapps.model.internal.intermediates.Usage;
import com.autonomousapps.tasks.ReasonTask;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0006234567B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010-\u001a\u00020.H\u0007J\b\u0010/\u001a\u00020\fH\u0002J\b\u00100\u001a\u000201H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR*\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00188gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\bR\u0014\u0010\u001d\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\bR*\u0010\u001f\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u000f\"\u0004\b!\u0010\u0011R*\u0010\"\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f8G@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u000f\"\u0004\b$\u0010\u0011R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0&8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0&8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u0014\u0010+\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/autonomousapps/tasks/ReasonTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "annotationProcessorUsageReport", "Lorg/gradle/api/file/RegularFileProperty;", "getAnnotationProcessorUsageReport", "()Lorg/gradle/api/file/RegularFileProperty;", "bundleTracesReport", "getBundleTracesReport", "<set-?>", "", "capability", "getCapability", "()Ljava/lang/String;", "setCapability", "(Ljava/lang/String;)V", "dependencyGraphViews", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/RegularFile;", "getDependencyGraphViews", "()Lorg/gradle/api/provider/ListProperty;", "dependencyMap", "Lorg/gradle/api/provider/MapProperty;", "getDependencyMap", "()Lorg/gradle/api/provider/MapProperty;", "dependencyUsageReport", "getDependencyUsageReport", "finalAdviceReport", "getFinalAdviceReport", "id", "getId", "setId", "module", "getModule", "setModule", "projectPath", "Lorg/gradle/api/provider/Property;", "getProjectPath", "()Lorg/gradle/api/provider/Property;", "rootProjectName", "getRootProjectName", "unfilteredAdviceReport", "getUnfilteredAdviceReport", "action", "", "help", "options", "Lcom/autonomousapps/tasks/ReasonTask$Options;", "ExplainDependencyAdviceAction", "ExplainDependencyAdviceParams", "ExplainModuleAdviceAction", "ExplainModuleAdviceParams", "Explainer", "Options", "dependency-analysis-gradle-plugin"})
public abstract class ReasonTask
extends DefaultTask {
    @NotNull
    private final WorkerExecutor workerExecutor;
    @Nullable
    private String id;
    @Nullable
    private String capability;
    @Nullable
    private String module;

    @Inject
    public ReasonTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
        this.setGroup("dependency-analysis");
        this.setDescription("Explain how a dependency is used");
    }

    @Input
    @NotNull
    public abstract Property<String> getRootProjectName();

    @Input
    @NotNull
    public abstract Property<String> getProjectPath();

    @Optional
    @Input
    @Nullable
    public final String getId() {
        return this.id;
    }

    @Option(option="id", description="The dependency you'd like to reason about (com.foo:bar:1.0 or :other:module)")
    public final void setId(@Nullable String string) {
        this.id = string;
    }

    @Optional
    @Input
    @Nullable
    public final String getCapability() {
        return this.capability;
    }

    @Option(option="capability", description="The capability you're interested in. Defaults to main capability. A typical option is 'test-fixtures'")
    public final void setCapability(@Nullable String string) {
        this.capability = string;
    }

    @Optional
    @Input
    @Nullable
    public final String getModule() {
        return this.module;
    }

    @Option(option="module", description="The module-structure-related advice you'd like more insight into ('android')")
    public final void setModule(@Nullable String string) {
        this.module = string;
    }

    @Input
    @NotNull
    public abstract MapProperty<String, String> getDependencyMap();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getDependencyUsageReport();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getAnnotationProcessorUsageReport();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getUnfilteredAdviceReport();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getFinalAdviceReport();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getBundleTracesReport();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ListProperty<RegularFile> getDependencyGraphViews();

    @TaskAction
    public final void action() {
        block1: {
            Options options = this.options();
            String string = options.getId();
            if (string != null) {
                String dependency = string;
                boolean bl = false;
                this.workerExecutor.noIsolation().submit(ExplainDependencyAdviceAction.class, new Action(dependency, options, this){
                    final /* synthetic */ String $dependency;
                    final /* synthetic */ Options $options;
                    final /* synthetic */ ReasonTask this$0;
                    {
                        this.$dependency = $dependency;
                        this.$options = $options;
                        this.this$0 = $receiver;
                    }

                    public final void execute(ExplainDependencyAdviceParams $this$submit) {
                        Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$this$submit");
                        $this$submit.getId().set((Object)this.$dependency);
                        Property<String> property = $this$submit.getCapability();
                        String string = this.$options.getCapability();
                        if (string == null) {
                            string = "";
                        }
                        property.set((Object)string);
                        $this$submit.getRootProjectName().set((Provider)this.this$0.getRootProjectName());
                        $this$submit.getProjectPath().set((Provider)this.this$0.getProjectPath());
                        $this$submit.getDependencyMap().set((Provider)this.this$0.getDependencyMap());
                        $this$submit.getDependencyUsageReport().set((Provider)this.this$0.getDependencyUsageReport());
                        $this$submit.getAnnotationProcessorUsageReport().set((Provider)this.this$0.getAnnotationProcessorUsageReport());
                        $this$submit.getUnfilteredAdviceReport().set((Provider)this.this$0.getUnfilteredAdviceReport());
                        $this$submit.getFinalAdviceReport().set((Provider)this.this$0.getFinalAdviceReport());
                        $this$submit.getBundleTracesReport().set((Provider)this.this$0.getBundleTracesReport());
                        $this$submit.getDependencyGraphViews().set((Provider)this.this$0.getDependencyGraphViews());
                    }
                });
            }
            String string2 = options.getModule();
            if (string2 == null) break block1;
            String moduleStructure = string2;
            boolean bl = false;
            this.workerExecutor.noIsolation().submit(ExplainModuleAdviceAction.class, new Action(moduleStructure, this){
                final /* synthetic */ String $moduleStructure;
                final /* synthetic */ ReasonTask this$0;
                {
                    this.$moduleStructure = $moduleStructure;
                    this.this$0 = $receiver;
                }

                public final void execute(ExplainModuleAdviceParams $this$submit) {
                    Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$this$submit");
                    $this$submit.getModule().set((Object)this.$moduleStructure);
                    $this$submit.getProjectPath().set((Provider)this.this$0.getProjectPath());
                    $this$submit.getUnfilteredAdviceReport().set((Provider)this.this$0.getUnfilteredAdviceReport());
                    $this$submit.getFinalAdviceReport().set((Provider)this.this$0.getFinalAdviceReport());
                }
            });
        }
    }

    private final Options options() {
        String id = this.id;
        String module = this.module;
        String capability = this.capability;
        if (id == null && module == null) {
            throw new InvalidUserDataException(this.help());
        }
        if (capability != null && id == null) {
            throw new InvalidUserDataException(this.help());
        }
        return new Options(id, capability, module);
    }

    private final String help() {
        String path = (String)this.getProjectPath().get();
        boolean bl = false;
        return StringsKt.trimIndent((String)("\n      You must call 'reason' with either the `--id` or `--module` option, or both.\n      You may also specify a `--capability`, but this only influences the results of an `--id` query.\n      \n      Usage for --id:\n        ./gradlew " + path + ":reason --id com.foo:bar:1.0\n        ./gradlew " + path + ":reason --id com.foo:bar\n        ./gradlew " + path + ":reason --id :other:module\n        ./gradlew " + path + ":reason --id <dependency identifier> --capability test-fixtures\n        \n      For external dependencies, the version is optional.\n      Capability is optional. If unspecified, defaults to main capability.\n      \n      Usage for --module:\n        ./gradlew " + path + ":reason --module android\n    "));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0007H\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\"\u001a\u00020\u0012H\u0002J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010'\u001a\u00020\u0017H\u0002J\b\u0010(\u001a\u00020%H\u0002R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceParams;", "()V", "annotationProcessorUsages", "", "", "", "Lcom/autonomousapps/model/internal/intermediates/Usage;", "capability", "dependencyGraph", "Lcom/autonomousapps/model/internal/DependencyGraphView;", "dependencyMap", "Lkotlin/Function1;", "dependencyUsages", "finalAdvice", "Lcom/autonomousapps/model/Advice;", "finalProjectAdvice", "Lcom/autonomousapps/model/ProjectAdvice;", "logger", "Lorg/gradle/api/logging/Logger;", "projectPath", "requestedCoord", "Lcom/autonomousapps/model/Coordinates;", "rootProjectName", "targetCoord", "unfilteredAdvice", "unfilteredProjectAdvice", "usages", "bundleTraces", "Lcom/autonomousapps/model/internal/intermediates/BundleTrace;", "execute", "", "findAdviceIn", "projectAdvice", "getRequestedCoordinates", "normalize", "", "getUsageFor", "coordinates", "wasFiltered", "Companion", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nReasonTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction\n+ 2 logging.kt\ncom/autonomousapps/internal/utils/LoggingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 5 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 6 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 8 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n*L\n1#1,439:1\n21#2:440\n1557#3:441\n1628#3,2:442\n1630#3:458\n1202#3,2:459\n1230#3,4:461\n865#3,2:560\n865#3,2:578\n1755#3,3:580\n122#4,8:444\n117#4,13:465\n117#4,13:484\n76#4,17:503\n76#4,17:529\n46#4,8:562\n40#5,2:452\n33#5,4:454\n40#5,2:478\n33#5,4:480\n40#5,2:497\n33#5,4:499\n96#5:520\n59#5,4:521\n33#5,4:525\n96#5:546\n59#5,4:547\n33#5,4:551\n49#5,3:570\n33#5,4:573\n1104#6,3:555\n1#7:558\n76#8:559\n76#8:577\n*S KotlinDebug\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction\n*L\n207#1:440\n213#1:441\n213#1:442,2\n213#1:458\n214#1:459,2\n214#1:461,4\n344#1:560,2\n353#1:578,2\n359#1:580,3\n213#1:444,8\n215#1:465,13\n216#1:484,13\n219#1:503,17\n220#1:529,17\n353#1:562,8\n213#1:452,2\n213#1:454,4\n215#1:478,2\n215#1:480,4\n216#1:497,2\n216#1:499,4\n219#1:520\n219#1:521,4\n219#1:525,4\n220#1:546\n220#1:547,4\n220#1:551,4\n353#1:570,3\n353#1:573,4\n289#1:555,3\n344#1:559\n353#1:577\n*E\n"})
    public static abstract class ExplainDependencyAdviceAction
    implements WorkAction<ExplainDependencyAdviceParams> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Logger logger;
        @NotNull
        private final String capability;
        @NotNull
        private final String rootProjectName;
        @NotNull
        private final String projectPath;
        @NotNull
        private final Map<String, DependencyGraphView> dependencyGraph;
        @NotNull
        private final ProjectAdvice unfilteredProjectAdvice;
        @NotNull
        private final ProjectAdvice finalProjectAdvice;
        @NotNull
        private final Function1<String, String> dependencyMap;
        @NotNull
        private final Map<String, Set<Usage>> dependencyUsages;
        @NotNull
        private final Map<String, Set<Usage>> annotationProcessorUsages;
        @NotNull
        private final Coordinates targetCoord;
        @NotNull
        private final Coordinates requestedCoord;
        @NotNull
        private final Set<Advice> finalAdvice;
        @NotNull
        private final Set<Advice> unfilteredAdvice;
        @NotNull
        private final Set<Usage> usages;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public ExplainDependencyAdviceAction() {
            boolean $i$f$withNulls;
            Type[] $this$withNulls$iv$iv$iv$iv$iv;
            boolean $i$f$getJsonAdapter;
            boolean withNulls$iv$iv$iv$iv;
            boolean bl;
            Object reader$iv$iv$iv2;
            RegularFileProperty $this$fromJson$iv;
            Object element$iv$iv2;
            void $this$associateByTo$iv$iv;
            RegularFileProperty $this$associateBy$iv;
            Object object;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            boolean $i$f$getLogger22 = false;
            Logger logger = Logging.getLogger(ReasonTask.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(T::class.java)");
            this.logger = logger;
            Object object2 = ((ExplainDependencyAdviceParams)this.getParameters()).getCapability().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.capability.get()");
            this.capability = (String)object2;
            Object object3 = ((ExplainDependencyAdviceParams)this.getParameters()).getRootProjectName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.rootProjectName.get()");
            this.rootProjectName = (String)object3;
            Object object4 = ((ExplainDependencyAdviceParams)this.getParameters()).getProjectPath().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"parameters.projectPath.get()");
            this.projectPath = (String)object4;
            Object object5 = ((ExplainDependencyAdviceParams)this.getParameters()).getDependencyGraphViews().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"parameters.dependencyGraphViews.get()");
            Iterable $i$f$getLogger22 = (Iterable)object5;
            ExplainDependencyAdviceAction explainDependencyAdviceAction = this;
            boolean $i$f$map = false;
            void var3_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                Object object6;
                File $this$fromJson$iv$iv;
                void it;
                RegularFile regularFile = (RegularFile)item$iv$iv2;
                object = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                void $this$fromJson$iv2 = it;
                boolean $i$f$fromJson = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$fromJson$iv2.getAsFile(), (String)"asFile");
                boolean $i$f$fromJson2 = false;
                Closeable closeable = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv);
                Throwable throwable = null;
                try {
                    JsonAdapter $this$withNulls$iv$iv$iv$iv;
                    BufferedSource reader$iv$iv = (BufferedSource)closeable;
                    boolean bl3 = false;
                    boolean withNulls$iv$iv$iv = false;
                    boolean $i$f$getJsonAdapter2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)MoshiUtils.getMOSHI().adapter(DependencyGraphView.class), (String)"MOSHI.adapter(T::class.java)");
                    boolean $i$f$withNulls2 = false;
                    Intrinsics.checkNotNull((Object)$this$withNulls$iv$iv$iv$iv.fromJson(reader$iv$iv));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object.add((DependencyGraphView)object6);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
                void it;
                DependencyGraphView bl2 = (DependencyGraphView)element$iv$iv2;
                object = destination$iv$iv2;
                boolean bl4 = false;
                object.put(it.getName() + "," + it.getConfigurationName(), element$iv$iv2);
            }
            explainDependencyAdviceAction.dependencyGraph = destination$iv$iv2;
            $this$associateBy$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getUnfilteredAdviceReport();
            explainDependencyAdviceAction = this;
            boolean $i$f$fromJson = false;
            Object object7 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"get()");
            RegularFile $this$fromJson$iv$iv = (RegularFile)object7;
            boolean $i$f$fromJson3 = false;
            File file = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"asFile");
            File $this$fromJson$iv$iv$iv = file;
            boolean $i$f$fromJson4 = false;
            item$iv$iv2 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            element$iv$iv2 = null;
            try {
                reader$iv$iv$iv2 = (BufferedSource)item$iv$iv2;
                bl = false;
                withNulls$iv$iv$iv$iv = false;
                $i$f$getJsonAdapter = false;
                Type[] typeArray = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"MOSHI.adapter(T::class.java)");
                $this$withNulls$iv$iv$iv$iv$iv = typeArray;
                $i$f$withNulls = false;
                Object object8 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv2);
                Intrinsics.checkNotNull((Object)object8);
                reader$iv$iv$iv2 = object8;
            }
            catch (Throwable reader$iv$iv$iv2) {
                element$iv$iv2 = reader$iv$iv$iv2;
                throw reader$iv$iv$iv2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)item$iv$iv2, element$iv$iv2);
            }
            explainDependencyAdviceAction.unfilteredProjectAdvice = (ProjectAdvice)reader$iv$iv$iv2;
            $this$fromJson$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getFinalAdviceReport();
            explainDependencyAdviceAction = this;
            $i$f$fromJson = false;
            Object object9 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"get()");
            $this$fromJson$iv$iv = (RegularFile)object9;
            $i$f$fromJson3 = false;
            File file2 = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"asFile");
            $this$fromJson$iv$iv$iv = file2;
            $i$f$fromJson4 = false;
            item$iv$iv2 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            element$iv$iv2 = null;
            try {
                reader$iv$iv$iv2 = (BufferedSource)item$iv$iv2;
                bl = false;
                withNulls$iv$iv$iv$iv = false;
                $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
                $this$withNulls$iv$iv$iv$iv$iv = jsonAdapter;
                $i$f$withNulls = false;
                Object object10 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv2);
                Intrinsics.checkNotNull((Object)object10);
                reader$iv$iv$iv2 = object10;
            }
            catch (Throwable reader$iv$iv$iv3) {
                element$iv$iv2 = reader$iv$iv$iv3;
                throw reader$iv$iv$iv3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)item$iv$iv2, element$iv$iv2);
            }
            explainDependencyAdviceAction.finalProjectAdvice = (ProjectAdvice)reader$iv$iv$iv2;
            Object object11 = ((ExplainDependencyAdviceParams)this.getParameters()).getDependencyMap().get();
            Intrinsics.checkNotNullExpressionValue((Object)object11, (String)"parameters.dependencyMap.get()");
            this.dependencyMap = DependenciesHandler.Companion.toLambda((Map)object11);
            RegularFileProperty $this$fromJsonMapSet$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getDependencyUsageReport();
            boolean $i$f$fromJsonMapSet = false;
            Object object12 = $this$fromJsonMapSet$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object12, (String)"get()");
            RegularFile $this$fromJsonMapSet$iv$iv = (RegularFile)object12;
            boolean $i$f$fromJsonMapSet2 = false;
            File file3 = $this$fromJsonMapSet$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"asFile");
            File $this$fromJsonMapSet$iv$iv$iv = file3;
            boolean $i$f$fromJsonMapSet3 = false;
            BufferedSource $this$fromJsonMapSet$iv$iv$iv$iv = UtilsKt.access$bufferRead($this$fromJsonMapSet$iv$iv$iv);
            boolean $i$f$fromJsonMapSet4 = false;
            boolean withNulls$iv$iv$iv$iv$iv = false;
            boolean $i$f$getJsonMapSetAdapter = false;
            Type[] withNulls$iv$iv$iv$iv2 = new Type[]{Usage.class};
            ParameterizedType setType$iv$iv$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])withNulls$iv$iv$iv$iv2);
            $this$withNulls$iv$iv$iv$iv$iv = new Type[]{String.class, setType$iv$iv$iv$iv$iv};
            Object mapType$iv$iv$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Map.class)), (Type[])$this$withNulls$iv$iv$iv$iv$iv);
            Type[] typeArray = MoshiUtils.getMOSHI().adapter((Type)mapType$iv$iv$iv$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"MOSHI.adapter<Map<K, Set<V>>>(mapType)");
            Type[] $this$withNulls$iv$iv$iv$iv$iv$iv = typeArray;
            $i$f$withNulls = false;
            Object object13 = $this$withNulls$iv$iv$iv$iv$iv$iv.fromJson($this$fromJsonMapSet$iv$iv$iv$iv);
            Intrinsics.checkNotNull((Object)object13);
            this.dependencyUsages = (Map)object13;
            $this$fromJsonMapSet$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getAnnotationProcessorUsageReport();
            $i$f$fromJsonMapSet = false;
            Object object14 = $this$fromJsonMapSet$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object14, (String)"get()");
            $this$fromJsonMapSet$iv$iv = (RegularFile)object14;
            $i$f$fromJsonMapSet2 = false;
            File file4 = $this$fromJsonMapSet$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"asFile");
            $this$fromJsonMapSet$iv$iv$iv = file4;
            $i$f$fromJsonMapSet3 = false;
            $this$fromJsonMapSet$iv$iv$iv$iv = UtilsKt.access$bufferRead($this$fromJsonMapSet$iv$iv$iv);
            $i$f$fromJsonMapSet4 = false;
            withNulls$iv$iv$iv$iv$iv = false;
            $i$f$getJsonMapSetAdapter = false;
            mapType$iv$iv$iv$iv$iv = new Type[]{Usage.class};
            setType$iv$iv$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])mapType$iv$iv$iv$iv$iv);
            $this$withNulls$iv$iv$iv$iv$iv$iv = new Type[]{String.class, setType$iv$iv$iv$iv$iv};
            mapType$iv$iv$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Map.class)), (Type[])$this$withNulls$iv$iv$iv$iv$iv$iv);
            Type[] typeArray2 = MoshiUtils.getMOSHI().adapter((Type)mapType$iv$iv$iv$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)typeArray2, (String)"MOSHI.adapter<Map<K, Set<V>>>(mapType)");
            $this$withNulls$iv$iv$iv$iv$iv$iv = typeArray2;
            $i$f$withNulls = false;
            Object object15 = $this$withNulls$iv$iv$iv$iv$iv$iv.fromJson($this$fromJsonMapSet$iv$iv$iv$iv);
            Intrinsics.checkNotNull((Object)object15);
            this.annotationProcessorUsages = (Map)object15;
            this.targetCoord = this.getRequestedCoordinates(true);
            this.requestedCoord = this.getRequestedCoordinates(false);
            this.finalAdvice = this.findAdviceIn(this.finalProjectAdvice);
            this.unfilteredAdvice = this.findAdviceIn(this.unfilteredProjectAdvice);
            this.usages = this.getUsageFor(this.targetCoord);
        }

        public void execute() {
            String reason = new DependencyAdviceExplainer(new ProjectCoordinates(this.projectPath, new GradleVariantIdentification(SetsKt.setOf((Object)"ROOT"), MapsKt.emptyMap()), ":"), this.requestedCoord, this.targetCoord, this.capability, this.usages, this.finalAdvice, this.dependencyGraph, this.bundleTraces(), this.wasFiltered(), this.dependencyMap).computeReason();
            this.logger.quiet(reason);
        }

        private final Coordinates getRequestedCoordinates(boolean normalize) {
            Coordinates coordinates;
            String includedBuildId;
            String capabilitySuffix;
            String string;
            Object object = ((ExplainDependencyAdviceParams)this.getParameters()).getId().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.id.get()");
            String requestedId = (String)object;
            String requestedCapability = this.capability;
            boolean requestedViaProjectPath = StringsKt.startsWith$default((String)requestedId, (String)":", (boolean)false, (int)2, null);
            String string2 = Companion.findFilteredDependencyKey$dependency_analysis_gradle_plugin(this.dependencyUsages.entrySet(), requestedId);
            if (string2 == null && (string2 = Companion.findFilteredDependencyKey$dependency_analysis_gradle_plugin(this.annotationProcessorUsages.entrySet(), requestedId)) == null && (string2 = ExplainDependencyAdviceAction.getRequestedCoordinates$findInGraph(this, requestedId)) == null) {
                throw new InvalidUserDataException("There is no dependency with coordinates '" + requestedId + "' in this project.");
            }
            String gavKey = string2;
            if (requestedViaProjectPath && !normalize) {
                string = CoordinatesString.Companion.secondCoordinatesKeySegment(gavKey);
                if (string == null) {
                    string = gavKey;
                }
            } else {
                string = CoordinatesString.Companion.firstCoordinatesKeySegment(gavKey);
            }
            String gav2 = string;
            String string3 = capabilitySuffix = ((CharSequence)requestedCapability).length() == 0 ? "" : (Intrinsics.areEqual((Object)requestedCapability, (Object)"testFixtures") ? "-test-fixtures" : "-" + requestedCapability);
            Set<String> set2 = CoordinatesString.Companion.of(gavKey).getCapabilities();
            if (set2 == null || (set2 = (String)kotlin.collections.CollectionsKt.singleOrNull((Iterable)set2)) == null) {
                set2 = "";
            }
            Set<String> baseCapability = set2;
            String syntheticCapability = (String)((Object)baseCapability) + capabilitySuffix;
            CharSequence $this$count$iv = requestedId;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int j = 0; j < $this$count$iv.length(); ++j) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(j);
                boolean bl = false;
                if (!(it == ':')) continue;
                ++count$iv;
            }
            String string4 = includedBuildId = count$iv == 1 ? this.rootProjectName + requestedId : this.rootProjectName + com.autonomousapps.internal.utils.strings.StringsKt.replaceExceptLast$default(requestedId, ":", ".", false, 4, null);
            if (Intrinsics.areEqual((Object)gav2, (Object)includedBuildId)) {
                GradleVariantIdentification gradleVariantIdentification = new GradleVariantIdentification(SetsKt.setOf((Object)syntheticCapability), MapsKt.emptyMap());
                coordinates = new IncludedBuildCoordinates(includedBuildId, new ProjectCoordinates(requestedId, gradleVariantIdentification, ":"), gradleVariantIdentification);
            } else {
                Collection collection;
                Set capabilities = ((CharSequence)syntheticCapability).length() > 0 ? SetsKt.setOf((Object)syntheticCapability) : SetsKt.emptySet();
                Coordinates coord = Coordinates.Companion.of(gav2);
                Coordinates.Companion companion = Coordinates.Companion;
                Coordinates coordinates2 = coord;
                Collection collection2 = capabilities;
                if (collection2.isEmpty()) {
                    Coordinates coordinates3 = coordinates2;
                    Coordinates.Companion companion2 = companion;
                    boolean bl = false;
                    Set set3 = SetsKt.setOf((Object)coord.getIdentifier());
                    companion = companion2;
                    coordinates2 = coordinates3;
                    collection = set3;
                } else {
                    collection = collection2;
                }
                Map map = MapsKt.emptyMap();
                Set set4 = (Set)collection;
                coordinates = companion.copy$dependency_analysis_gradle_plugin(coordinates2, new GradleVariantIdentification(set4, map));
            }
            return coordinates;
        }

        private final Set<Usage> getUsageFor(Coordinates coordinates) {
            Set<Usage> set2;
            Set set3;
            Object v0;
            Set<Usage> set4;
            block4: {
                set4 = (Set<Usage>)this.dependencyUsages.entrySet();
                for (Object object : set4) {
                    Map.Entry entry = (Map.Entry)object;
                    boolean bl = false;
                    if (!CoordinatesString.Companion.of((String)entry.getKey()).matches(coordinates)) continue;
                    v0 = object;
                    break block4;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            if (entry != null && (set3 = (Set)entry.getValue()) != null && (set4 = CollectionsKt.softSortedSet(set3, Usage.Companion.getBY_VARIANT())) != null) {
                set2 = set4;
            } else {
                Set set5;
                Object v2;
                block5: {
                    Iterable iterable = this.annotationProcessorUsages.entrySet();
                    for (Object t : iterable) {
                        Map.Entry entry2 = (Map.Entry)t;
                        boolean bl = false;
                        if (!CoordinatesString.Companion.of((String)entry2.getKey()).matches(coordinates)) continue;
                        v2 = t;
                        break block5;
                    }
                    v2 = null;
                }
                Map.Entry entry3 = v2;
                set2 = entry3 != null && (set5 = (Set)entry3.getValue()) != null ? CollectionsKt.softSortedSet(set5, Usage.Companion.getBY_VARIANT()) : SetsKt.emptySet();
            }
            return set2;
        }

        /*
         * WARNING - void declaration
         */
        private final Set<Advice> findAdviceIn(ProjectAdvice projectAdvice2) {
            void $this$filterTo$iv$iv;
            Iterable $this$filterToSet$iv = projectAdvice2.getDependencyAdvice();
            boolean $i$f$filterToSet = false;
            Iterable iterable = $this$filterToSet$iv;
            Collection destination$iv$iv = new HashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Advice advice = (Advice)element$iv$iv;
                boolean bl = false;
                String adviceGav = advice.getCoordinates().gav();
                if (!(Intrinsics.areEqual((Object)adviceGav, (Object)this.targetCoord.gav()) || Intrinsics.areEqual((Object)adviceGav, (Object)this.requestedCoord.gav()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (Set)destination$iv$iv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final Set<BundleTrace> bundleTraces() {
            void $this$filterTo$iv$iv;
            Object object;
            RegularFileProperty $this$fromJsonSet$iv = ((ExplainDependencyAdviceParams)this.getParameters()).getBundleTracesReport();
            boolean $i$f$fromJsonSet = false;
            Object object2 = $this$fromJsonSet$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get()");
            Object $this$fromJsonSet$iv$iv = (RegularFile)object2;
            boolean $i$f$fromJsonSet2 = false;
            File file = $this$fromJsonSet$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"asFile");
            Closeable closeable = (Closeable)UtilsKt.access$bufferRead(file);
            Object object3 = null;
            try {
                Object source$iv$iv = (BufferedSource)closeable;
                boolean bl = false;
                boolean withNulls$iv$iv$iv = false;
                boolean $i$f$getJsonSetAdapter = false;
                Type[] typeArray = new Type[]{BundleTrace.class};
                ParameterizedType type$iv$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])typeArray);
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter<Set<T>>(type)");
                JsonAdapter $this$withNulls$iv$iv$iv$iv = jsonAdapter;
                boolean $i$f$withNulls = false;
                Object object4 = $this$withNulls$iv$iv$iv$iv.fromJson(source$iv$iv);
                Intrinsics.checkNotNull((Object)object4);
                source$iv$iv = (Set)object4;
                object = source$iv$iv;
            }
            catch (Throwable source$iv$iv) {
                object3 = source$iv$iv;
                throw source$iv$iv;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object3);
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"asFile.bufferRead().use \u2026().fromJson(source)!!\n  }");
            Iterable $this$filterToSet$iv = (Iterable)object;
            boolean $i$f$filterToSet = false;
            $this$fromJsonSet$iv$iv = $this$filterToSet$iv;
            Collection destination$iv$iv = new HashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                BundleTrace it = (BundleTrace)element$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getTop().gav(), (Object)this.targetCoord.gav()) || Intrinsics.areEqual((Object)it.getBottom().gav(), (Object)this.targetCoord.gav()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (Set)destination$iv$iv;
        }

        private final boolean wasFiltered() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.unfilteredAdvice;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Advice unfiltered = (Advice)element$iv;
                        boolean bl2 = false;
                        if (!(!this.finalAdvice.contains(unfiltered))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private static final String getRequestedCoordinates$findInGraph(ExplainDependencyAdviceAction this$0, String requestedId) {
            Object v0;
            block1: {
                Sequence sequence = SequencesKt.flatMapIterable((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)this$0.dependencyGraph.values()), (Function1)getRequestedCoordinates.findInGraph.1.INSTANCE);
                for (Object e : sequence) {
                    Coordinates coordinates = (Coordinates)e;
                    boolean bl = false;
                    String gav2 = coordinates.gav();
                    if (!(Intrinsics.areEqual((Object)gav2, (Object)requestedId) || StringsKt.startsWith$default((String)gav2, (String)(requestedId + ":"), (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)this$0.dependencyMap.invoke((Object)gav2), (Object)requestedId) || Intrinsics.areEqual((Object)this$0.dependencyMap.invoke((Object)coordinates.getIdentifier()), (Object)requestedId))) continue;
                    v0 = e;
                    break block1;
                }
                v0 = null;
            }
            Coordinates coordinates = v0;
            return coordinates != null ? coordinates.gav() : null;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u00070\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction$Companion;", "", "()V", "findFilteredDependencyKey", "", "dependencies", "", "", "requestedId", "findFilteredDependencyKey$dependency_analysis_gradle_plugin", "dependency-analysis-gradle-plugin"})
        @SourceDebugExtension(value={"SMAP\nReasonTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,439:1\n1557#2:440\n1628#2,3:441\n*S KotlinDebug\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceAction$Companion\n*L\n384#1:440\n384#1:441,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final String findFilteredDependencyKey$dependency_analysis_gradle_plugin(@NotNull Set<? extends Map.Entry<String, ? extends Object>> dependencies2, @NotNull String requestedId) {
                String string;
                Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
                Intrinsics.checkNotNullParameter((Object)requestedId, (String)"requestedId");
                LinkedHashSet<String> filteredKeys = new LinkedHashSet<String>();
                for (Map.Entry<String, ? extends Object> entry : dependencies2) {
                    if (CoordinatesString.Companion.equalsKey(requestedId, entry)) {
                        return entry.getKey();
                    }
                    if (!CoordinatesString.Companion.matchesKey(requestedId, entry)) continue;
                    filteredKeys.add(CoordinatesString.Companion.of(entry.getKey()).fullGav());
                }
                if (filteredKeys.isEmpty()) {
                    string = null;
                } else if (filteredKeys.size() == 1) {
                    string = (String)filteredKeys.iterator().next();
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = filteredKeys;
                    String string2 = requestedId;
                    boolean bl = false;
                    void var6_8 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string3 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        String string4 = CoordinatesString.Companion.secondCoordinatesKeySegment((String)it);
                        if (string4 == null) {
                            string4 = it;
                        }
                        collection.add(string4);
                    }
                    String string5 = "Coordinates '" + string2 + "' matches more than 1 dependency " + (List)destination$iv$iv;
                    throw new InvalidUserDataException(string5);
                }
                return string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0005R\u0012\u0010\u0018\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0005R\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\fR\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\fR\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\fR\u0012\u0010 \u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\"\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainDependencyAdviceParams;", "Lorg/gradle/workers/WorkParameters;", "annotationProcessorUsageReport", "Lorg/gradle/api/file/RegularFileProperty;", "getAnnotationProcessorUsageReport", "()Lorg/gradle/api/file/RegularFileProperty;", "bundleTracesReport", "getBundleTracesReport", "capability", "Lorg/gradle/api/provider/Property;", "", "getCapability", "()Lorg/gradle/api/provider/Property;", "dependencyGraphViews", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/RegularFile;", "getDependencyGraphViews", "()Lorg/gradle/api/provider/ListProperty;", "dependencyMap", "Lorg/gradle/api/provider/MapProperty;", "getDependencyMap", "()Lorg/gradle/api/provider/MapProperty;", "dependencyUsageReport", "getDependencyUsageReport", "finalAdviceReport", "getFinalAdviceReport", "id", "getId", "projectPath", "getProjectPath", "rootProjectName", "getRootProjectName", "unfilteredAdviceReport", "getUnfilteredAdviceReport", "dependency-analysis-gradle-plugin"})
    public static interface ExplainDependencyAdviceParams
    extends WorkParameters {
        @NotNull
        public Property<String> getId();

        @NotNull
        public Property<String> getCapability();

        @NotNull
        public Property<String> getRootProjectName();

        @NotNull
        public Property<String> getProjectPath();

        @NotNull
        public MapProperty<String, String> getDependencyMap();

        @NotNull
        public RegularFileProperty getDependencyUsageReport();

        @NotNull
        public RegularFileProperty getAnnotationProcessorUsageReport();

        @NotNull
        public RegularFileProperty getUnfilteredAdviceReport();

        @NotNull
        public RegularFileProperty getFinalAdviceReport();

        @NotNull
        public RegularFileProperty getBundleTracesReport();

        @NotNull
        public ListProperty<RegularFile> getDependencyGraphViews();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0002R\u0015\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\f\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceParams;", "()V", "finalAndroidScore", "Lcom/autonomousapps/model/AndroidScore;", "Lkotlin/internal/NoInfer;", "logger", "Lorg/gradle/api/logging/Logger;", "module", "", "projectPath", "unfilteredAndroidScore", "execute", "", "validateModuleOption", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nReasonTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceAction\n+ 2 logging.kt\ncom/autonomousapps/internal/utils/LoggingKt\n+ 3 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 4 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,439:1\n21#2:440\n117#3,13:441\n117#3,13:471\n40#4,2:454\n33#4,4:456\n40#4,2:484\n33#4,4:486\n808#5,11:460\n808#5,11:490\n*S KotlinDebug\n*F\n+ 1 ReasonTask.kt\ncom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceAction\n*L\n400#1:440\n405#1:441,13\n410#1:471,13\n405#1:454,2\n405#1:456,4\n410#1:484,2\n410#1:486,4\n407#1:460,11\n412#1:490,11\n*E\n"})
    public static abstract class ExplainModuleAdviceAction
    implements WorkAction<ExplainModuleAdviceParams> {
        @NotNull
        private final Logger logger;
        @NotNull
        private final String projectPath;
        @NotNull
        private final String module;
        @Nullable
        private final AndroidScore unfilteredAndroidScore;
        @Nullable
        private final AndroidScore finalAndroidScore;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public ExplainModuleAdviceAction() {
            Object object;
            Object element$iv$iv2;
            void $this$filterIsInstanceTo$iv$iv;
            RegularFileProperty $this$filterIsInstance$iv;
            boolean $i$f$withNulls;
            JsonAdapter $this$withNulls$iv$iv$iv$iv$iv;
            boolean $i$f$getJsonAdapter;
            boolean withNulls$iv$iv$iv$iv;
            boolean bl;
            Object reader$iv$iv$iv2;
            Iterable $this$fromJson$iv;
            boolean $i$f$getLogger22 = false;
            Logger logger = Logging.getLogger(ReasonTask.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(T::class.java)");
            this.logger = logger;
            Object object2 = ((ExplainModuleAdviceParams)this.getParameters()).getProjectPath().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.projectPath.get()");
            this.projectPath = (String)object2;
            Object object3 = ((ExplainModuleAdviceParams)this.getParameters()).getModule().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.module.get()");
            this.module = (String)object3;
            RegularFileProperty $i$f$getLogger22 = ((ExplainModuleAdviceParams)this.getParameters()).getUnfilteredAdviceReport();
            ExplainModuleAdviceAction explainModuleAdviceAction = this;
            boolean $i$f$fromJson = false;
            Object object4 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get()");
            RegularFile $this$fromJson$iv$iv = (RegularFile)object4;
            boolean $i$f$fromJson2 = false;
            File file = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"asFile");
            File $this$fromJson$iv$iv$iv = file;
            boolean $i$f$fromJson3 = false;
            Closeable closeable = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            Throwable throwable = null;
            try {
                reader$iv$iv$iv2 = (BufferedSource)closeable;
                bl = false;
                withNulls$iv$iv$iv$iv = false;
                $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
                $this$withNulls$iv$iv$iv$iv$iv = jsonAdapter;
                $i$f$withNulls = false;
                Object object5 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv2);
                Intrinsics.checkNotNull((Object)object5);
                reader$iv$iv$iv2 = object5;
            }
            catch (Throwable reader$iv$iv$iv2) {
                throwable = reader$iv$iv$iv2;
                throw reader$iv$iv$iv2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            $this$fromJson$iv = ((ProjectAdvice)reader$iv$iv$iv2).getModuleAdvice();
            boolean $i$f$filterIsInstance = false;
            $this$fromJson$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof AndroidScore)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            explainModuleAdviceAction.unfilteredAndroidScore = (AndroidScore)kotlin.collections.CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
            $this$filterIsInstance$iv = ((ExplainModuleAdviceParams)this.getParameters()).getFinalAdviceReport();
            explainModuleAdviceAction = this;
            $i$f$fromJson = false;
            Object object6 = $this$fromJson$iv.get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get()");
            $this$fromJson$iv$iv = (RegularFile)object6;
            $i$f$fromJson = false;
            File file2 = $this$fromJson$iv$iv.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"asFile");
            $this$fromJson$iv$iv$iv = file2;
            $i$f$fromJson = false;
            element$iv$iv2 = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
            throwable = null;
            try {
                reader$iv$iv$iv2 = (BufferedSource)element$iv$iv2;
                bl = false;
                withNulls$iv$iv$iv$iv = false;
                $i$f$getJsonAdapter = false;
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
                $this$withNulls$iv$iv$iv$iv$iv = jsonAdapter;
                $i$f$withNulls = false;
                Object object7 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv2);
                Intrinsics.checkNotNull((Object)object7);
                object = object7;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(element$iv$iv2, (Throwable)throwable);
            }
            $this$fromJson$iv = ((ProjectAdvice)object).getModuleAdvice();
            $i$f$filterIsInstance = false;
            $this$fromJson$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof AndroidScore)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            explainModuleAdviceAction.finalAndroidScore = (AndroidScore)kotlin.collections.CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        }

        public void execute() {
            this.validateModuleOption();
            String reason = new ModuleAdviceExplainer(new ProjectCoordinates(this.projectPath, GradleVariantIdentification.Companion.getEMPTY(), null, 4, null), this.unfilteredAndroidScore, this.finalAndroidScore).computeReason();
            this.logger.quiet(reason);
        }

        private final void validateModuleOption() {
            if (!Intrinsics.areEqual((Object)this.module, (Object)"android")) {
                throw new InvalidUserDataException("'" + this.module + "' unexpected. The only valid option for '--module' at this time is 'android'.");
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0012\u0010\r\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$ExplainModuleAdviceParams;", "Lorg/gradle/workers/WorkParameters;", "finalAdviceReport", "Lorg/gradle/api/file/RegularFileProperty;", "getFinalAdviceReport", "()Lorg/gradle/api/file/RegularFileProperty;", "module", "Lorg/gradle/api/provider/Property;", "", "getModule", "()Lorg/gradle/api/provider/Property;", "projectPath", "getProjectPath", "unfilteredAdviceReport", "getUnfilteredAdviceReport", "dependency-analysis-gradle-plugin"})
    public static interface ExplainModuleAdviceParams
    extends WorkParameters {
        @NotNull
        public Property<String> getModule();

        @NotNull
        public Property<String> getProjectPath();

        @NotNull
        public RegularFileProperty getUnfilteredAdviceReport();

        @NotNull
        public RegularFileProperty getFinalAdviceReport();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b`\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$Explainer;", "", "computeReason", "", "dependency-analysis-gradle-plugin"})
    public static interface Explainer {
        @NotNull
        public String computeReason();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/autonomousapps/tasks/ReasonTask$Options;", "", "id", "", "capability", "module", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCapability", "()Ljava/lang/String;", "getId", "getModule", "dependency-analysis-gradle-plugin"})
    private static final class Options {
        @Nullable
        private final String id;
        @Nullable
        private final String capability;
        @Nullable
        private final String module;

        public Options(@Nullable String id, @Nullable String capability, @Nullable String module) {
            this.id = id;
            this.capability = capability;
            this.module = module;
        }

        @Nullable
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getCapability() {
            return this.capability;
        }

        @Nullable
        public final String getModule() {
            return this.module;
        }
    }
}

