/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.analyzer;

import com.autonomousapps.internal.analyzer.JvmSourceSet;
import com.autonomousapps.model.source.SourceKind;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/autonomousapps/internal/analyzer/KotlinSourceSet;", "Lcom/autonomousapps/internal/analyzer/JvmSourceSet;", "sourceSet", "Lorg/gradle/api/tasks/SourceSet;", "sourceKind", "Lcom/autonomousapps/model/source/SourceKind;", "(Lorg/gradle/api/tasks/SourceSet;Lcom/autonomousapps/model/source/SourceKind;)V", "classesDirs", "Lorg/gradle/api/file/FileCollection;", "getClassesDirs", "()Lorg/gradle/api/file/FileCollection;", "compileClasspathConfigurationName", "", "getCompileClasspathConfigurationName", "()Ljava/lang/String;", "jarTaskName", "getJarTaskName", "name", "getName", "runtimeClasspathConfigurationName", "getRuntimeClasspathConfigurationName", "sourceCode", "Lorg/gradle/api/file/SourceDirectorySet;", "getSourceCode", "()Lorg/gradle/api/file/SourceDirectorySet;", "getSourceKind", "()Lcom/autonomousapps/model/source/SourceKind;", "dependency-analysis-gradle-plugin"})
public final class KotlinSourceSet
implements JvmSourceSet {
    @NotNull
    private final SourceKind sourceKind;
    @NotNull
    private final String name;
    @NotNull
    private final String jarTaskName;
    @NotNull
    private final SourceDirectorySet sourceCode;
    @NotNull
    private final String compileClasspathConfigurationName;
    @NotNull
    private final String runtimeClasspathConfigurationName;
    @NotNull
    private final FileCollection classesDirs;

    public KotlinSourceSet(@NotNull SourceSet sourceSet, @NotNull SourceKind sourceKind) {
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        Intrinsics.checkNotNullParameter((Object)sourceKind, (String)"sourceKind");
        this.sourceKind = sourceKind;
        String string = sourceSet.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceSet.name");
        this.name = string;
        this.jarTaskName = "jar";
        SourceDirectorySet sourceDirectorySet = sourceSet.getAllSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceDirectorySet, (String)"sourceSet.allSource");
        this.sourceCode = sourceDirectorySet;
        this.compileClasspathConfigurationName = !Intrinsics.areEqual((Object)this.getName(), (Object)"main") ? this.getName() + "CompileClasspath" : "compileClasspath";
        this.runtimeClasspathConfigurationName = !Intrinsics.areEqual((Object)this.getName(), (Object)"main") ? this.getName() + "RuntimeClasspath" : "runtimeClasspath";
        FileCollection fileCollection = sourceSet.getOutput().getClassesDirs();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"sourceSet.output.classesDirs");
        this.classesDirs = fileCollection;
    }

    @Override
    @NotNull
    public SourceKind getSourceKind() {
        return this.sourceKind;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getJarTaskName() {
        return this.jarTaskName;
    }

    @Override
    @NotNull
    public SourceDirectorySet getSourceCode() {
        return this.sourceCode;
    }

    @Override
    @NotNull
    public String getCompileClasspathConfigurationName() {
        return this.compileClasspathConfigurationName;
    }

    @Override
    @NotNull
    public String getRuntimeClasspathConfigurationName() {
        return this.runtimeClasspathConfigurationName;
    }

    @Override
    @NotNull
    public FileCollection getClassesDirs() {
        return this.classesDirs;
    }
}

