/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.abego.treelayout.util;

import com.autonomousapps.internal.abego.treelayout.Configuration;
import com.autonomousapps.internal.abego.treelayout.internal.util.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfiguration<TreeNode>
implements Configuration<TreeNode> {
    private final double gapBetweenLevels;
    private final double gapBetweenNodes;
    private final Configuration.Location location;
    private Configuration.AlignmentInLevel alignmentInLevel;

    public DefaultConfiguration(double gapBetweenLevels, double gapBetweenNodes, Configuration.Location location, Configuration.AlignmentInLevel alignmentInLevel) {
        Contract.checkArg(gapBetweenLevels >= 0.0, "gapBetweenLevels must be >= 0");
        Contract.checkArg(gapBetweenNodes >= 0.0, "gapBetweenNodes must be >= 0");
        this.gapBetweenLevels = gapBetweenLevels;
        this.gapBetweenNodes = gapBetweenNodes;
        this.location = location;
        this.alignmentInLevel = alignmentInLevel;
    }

    public DefaultConfiguration(double gapBetweenLevels, double gapBetweenNodes, Configuration.Location location) {
        this(gapBetweenLevels, gapBetweenNodes, location, Configuration.AlignmentInLevel.Center);
    }

    public DefaultConfiguration(double gapBetweenLevels, double gapBetweenNodes) {
        this(gapBetweenLevels, gapBetweenNodes, Configuration.Location.Top, Configuration.AlignmentInLevel.Center);
    }

    @Override
    public double getGapBetweenLevels(int nextLevel) {
        return this.gapBetweenLevels;
    }

    @Override
    public double getGapBetweenNodes(TreeNode node1, TreeNode node2) {
        return this.gapBetweenNodes;
    }

    @Override
    public Configuration.Location getRootLocation() {
        return this.location;
    }

    @Override
    public Configuration.AlignmentInLevel getAlignmentInLevel() {
        return this.alignmentInLevel;
    }
}

