/*
 * Decompiled with CFR 0.152.
 */
package com.authy.api;

import com.authy.AuthyException;
import com.authy.api.Error;
import com.authy.api.Formattable;
import com.authy.api.Resource;
import com.authy.api.Token;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class Tokens
extends Resource {
    public static final String TOKEN_VERIFICATION_PATH = "/protected/json/verify/";

    public Tokens(String uri, String key) {
        super(uri, key);
    }

    public Tokens(String uri, String key, boolean testFlag) {
        super(uri, key, testFlag);
    }

    public Token verify(int userId, String token) throws AuthyException {
        return this.verify(userId, token, null);
    }

    public Token verify(int userId, String token, Map<String, String> options) throws AuthyException {
        InternalToken internalToken = new InternalToken();
        internalToken.setOption(options);
        StringBuilder path = new StringBuilder(TOKEN_VERIFICATION_PATH);
        this.validateToken(token);
        path.append(token).append('/');
        path.append(userId);
        Resource.Response response = this.get(path.toString(), internalToken);
        return this.tokenFromJson(response.getStatus(), response.getBody());
    }

    private Token tokenFromJson(int status, String content) throws AuthyException {
        if (status == 200) {
            try {
                JSONObject tokenJSON = new JSONObject(content);
                String message = tokenJSON.optString("message");
                return new Token(status, content, message);
            }
            catch (JSONException e) {
                throw new AuthyException("Invalid response from server", e, status);
            }
        }
        Error error = this.errorFromJson(content);
        throw new AuthyException("Invalid token", status, error.getCode());
    }

    private void validateToken(String token) throws AuthyException {
        int len = token.length();
        if (!this.isInteger(token)) {
            throw new AuthyException("Invalid Token. Only digits accepted.", 400, Error.Code.TOKEN_INVALID);
        }
        if (len < 6 || len > 10) {
            throw new AuthyException("Invalid Token. Unexpected length.", 400, Error.Code.TOKEN_INVALID);
        }
    }

    private boolean isInteger(String s) {
        try {
            Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    class InternalToken
    implements Formattable {
        Map<String, String> options = new HashMap<String, String>();

        InternalToken() {
        }

        void setOption(Map<String, String> options) {
            if (options != null) {
                this.options = options;
            }
        }

        @Override
        public String toXML() {
            return null;
        }

        @Override
        public Map<String, String> toMap() {
            if (!this.options.containsKey("force")) {
                this.options.put("force", "true");
            }
            return this.options;
        }
    }
}

