/*
 * Decompiled with CFR 0.152.
 */
package com.authy.api;

import com.authy.AuthyException;
import com.authy.OneTouchException;
import com.authy.api.ApprovalRequestParams;
import com.authy.api.JSONBody;
import com.authy.api.Logo;
import com.authy.api.OneTouchResponse;
import com.authy.api.Params;
import com.authy.api.Resource;
import java.net.URLEncoder;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class OneTouch
extends Resource {
    public static final String APPROVAL_REQUEST_PRE = "/onetouch/json/users/";
    public static final String APPROVAL_REQUEST_POS = "/approval_requests";
    public static final String APPROVAL_REQUEST_STATUS = "/onetouch/json/approval_requests/";

    public OneTouch(String uri, String key) {
        super(uri, key, "application/json");
    }

    public OneTouch(String uri, String apiKey, boolean testFlag) {
        super(uri, apiKey, testFlag, "application/json");
    }

    public OneTouchResponse sendApprovalRequest(ApprovalRequestParams approvalRequestParams) throws AuthyException {
        Resource.Response response;
        OneTouchResponse oneTouchResponse;
        JSONObject params = new JSONObject();
        params.put("message", (Object)approvalRequestParams.getMessage());
        if (approvalRequestParams.getSecondsToExpire() != null) {
            params.put("seconds_to_expire", (Object)approvalRequestParams.getSecondsToExpire());
        }
        if (approvalRequestParams.getDetails().size() > 0) {
            params.put("details", (Object)this.mapToJSONObject(approvalRequestParams.getDetails()));
        }
        if (approvalRequestParams.getHidden().size() > 0) {
            params.put("hidden_details", (Object)this.mapToJSONObject(approvalRequestParams.getHidden()));
        }
        if (!approvalRequestParams.getLogos().isEmpty()) {
            JSONArray jSONArray = new JSONArray();
            for (Logo logo : approvalRequestParams.getLogos()) {
                logo.addToMap(jSONArray);
            }
            params.put("logos", (Object)jSONArray);
        }
        if (!(oneTouchResponse = new OneTouchResponse((response = this.post(APPROVAL_REQUEST_PRE + approvalRequestParams.getAuthyId() + APPROVAL_REQUEST_POS, new JSONBody(params))).getStatus(), response.getBody())).isOk()) {
            oneTouchResponse.setError(this.errorFromJson(response.getBody()));
        }
        return oneTouchResponse;
    }

    public OneTouchResponse getApprovalRequestStatus(String uuid) throws OneTouchException {
        try {
            Resource.Response response = this.get(APPROVAL_REQUEST_STATUS + URLEncoder.encode(uuid, "UTF-8"), new Params());
            OneTouchResponse oneTouchResponse = new OneTouchResponse(response.getStatus(), response.getBody());
            if (!oneTouchResponse.isOk()) {
                oneTouchResponse.setError(this.errorFromJson(response.getBody()));
            }
            return oneTouchResponse;
        }
        catch (Exception e) {
            throw new OneTouchException("There was an error trying to process this request.", e);
        }
    }

    private JSONObject mapToJSONObject(Map<String, String> map) {
        JSONObject obj = new JSONObject();
        for (String key : map.keySet()) {
            obj.put(key, (Object)map.get(key));
        }
        return obj;
    }
}

