/*
 * Decompiled with CFR 0.152.
 */
package com.authy;

import com.authy.OneTouchException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.json.JSONArray;
import org.json.JSONObject;

public class AuthyUtil {
    public static final String HEADER_AUTHY_SIGNATURE_NONCE = "X-Authy-Signature-Nonce";
    public static final String HEADER_AUTHY_SIGNATURE = "X-Authy-Signature";
    private static final Logger LOGGER = Logger.getLogger(AuthyUtil.class.getName());

    private static String hmacSha(String KEY, String VALUE) throws OneTouchException {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(KEY.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(VALUE.getBytes(StandardCharsets.UTF_8));
            return DatatypeConverter.printBase64Binary((byte[])rawHmac);
        }
        catch (Exception ex) {
            throw new OneTouchException("There was an exception checking the Authy OneTouch signature.", ex);
        }
    }

    private static boolean validateSignature(Map<String, String> parameters, Map<String, String> headers, String method, String url, String apiKey) throws OneTouchException, UnsupportedEncodingException {
        if (headers == null) {
            throw new OneTouchException("No headers sent");
        }
        if (!headers.containsKey(HEADER_AUTHY_SIGNATURE)) {
            throw new OneTouchException("'SIGNATURE' is missing.");
        }
        if (!headers.containsKey(HEADER_AUTHY_SIGNATURE_NONCE)) {
            throw new OneTouchException("'NONCE' is missing.");
        }
        if (parameters == null || parameters.isEmpty()) {
            throw new OneTouchException("'PARAMS' are missing.");
        }
        StringBuilder sb = new StringBuilder(headers.get(HEADER_AUTHY_SIGNATURE_NONCE)).append("|").append(method).append("|").append(url).append("|").append(AuthyUtil.mapToQuery(parameters));
        String signature = AuthyUtil.hmacSha(apiKey, sb.toString());
        return signature.equals(headers.get(HEADER_AUTHY_SIGNATURE));
    }

    public static void extract(String pre, JSONObject obj, HashMap<String, String> map) {
        for (String k : obj.keySet()) {
            String key;
            String string = key = pre.length() == 0 ? k : pre + "[" + k + "]";
            if (obj.optJSONObject(k) != null) {
                AuthyUtil.extract(key, obj.getJSONObject(k), map);
                continue;
            }
            if (obj.optJSONArray(k) != null) {
                JSONArray arr = obj.getJSONArray(k);
                int i = 0;
                for (Object tmp : arr) {
                    String tmpKey = key + "[" + i + "]";
                    if (tmp instanceof JSONObject) {
                        AuthyUtil.extract(tmpKey, (JSONObject)tmp, map);
                    } else {
                        map.put(tmpKey, AuthyUtil.getValue(tmp));
                    }
                    ++i;
                }
                continue;
            }
            map.put(key, AuthyUtil.getValue(obj.get(k)));
        }
    }

    private static String getValue(Object val) {
        if (val instanceof Boolean) {
            return Boolean.toString((Boolean)val);
        }
        if (val instanceof Integer) {
            return Long.toString(((Integer)val).intValue());
        }
        if (val instanceof Long) {
            return Long.toString((Long)val);
        }
        if (val instanceof Float) {
            return Float.toString(((Float)val).floatValue());
        }
        if (val instanceof Double) {
            return Double.toString((Double)val);
        }
        if (JSONObject.NULL.equals(val)) {
            return "";
        }
        return String.valueOf(val);
    }

    public static String mapToQuery(Map<String, String> map) throws OneTouchException, UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        TreeSet<String> keys = new TreeSet<String>(map.keySet());
        boolean first = true;
        for (String key : keys) {
            if (key.length() > 200) {
                throw new OneTouchException("max number of characters of key exceeded.");
            }
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            String value = map.get(key);
            if (value == null) continue;
            sb.append(URLEncoder.encode(key.replaceAll("\\[([0-9])*\\]", "[]"), StandardCharsets.UTF_8.name())).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8.name()));
        }
        return sb.toString();
    }

    public static boolean validateSignatureForPost(String body, Map<String, String> headers, String url, String apiKey) throws OneTouchException, UnsupportedEncodingException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (body == null || body.isEmpty()) {
            throw new OneTouchException("'PARAMS' are missing.");
        }
        AuthyUtil.extract("", new JSONObject(body), params);
        return AuthyUtil.validateSignature(params, headers, "POST", url, apiKey);
    }

    public static boolean validateSignatureForGet(Map<String, String> params, Map<String, String> headers, String url, String apiKey) throws OneTouchException, UnsupportedEncodingException {
        return AuthyUtil.validateSignature(params, headers, "GET", url, apiKey);
    }

    public static Properties loadProperties(String path, Class cls) {
        Properties properties = new Properties();
        try {
            InputStream in = cls.getResourceAsStream(path);
            if (in != null) {
                properties.load(in);
            }
            if (System.getenv("api_key") != null && System.getenv("api_url") != null) {
                properties.put("api_key", System.getenv("api_key"));
                properties.put("api_url", System.getenv("api_url"));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Problems loading properties", e);
        }
        return properties;
    }
}

