/*
 * Decompiled with CFR 0.152.
 */
package com.auth0;

import com.auth0.RandomStorage;
import com.auth0.RequestProcessor;
import com.auth0.SameSite;
import com.auth0.TransientCookieStore;
import com.auth0.client.auth.AuthAPI;
import com.auth0.client.auth.AuthorizeUrlBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthorizeUrl {
    private static final String SCOPE_OPENID = "openid";
    private HttpServletResponse response;
    private HttpServletRequest request;
    private final AuthorizeUrlBuilder builder;
    private final String responseType;
    private boolean useLegacySameSiteCookie = true;
    private boolean setSecureCookie = false;
    private String nonce;
    private String state;
    private boolean used;

    AuthorizeUrl(AuthAPI client, HttpServletRequest request, HttpServletResponse response, String redirectUrl, String responseType) {
        this.request = request;
        this.response = response;
        this.responseType = responseType;
        this.builder = client.authorizeUrl(redirectUrl).withResponseType(responseType).withScope(SCOPE_OPENID);
    }

    public AuthorizeUrl withOrganization(String organization) {
        this.builder.withOrganization(organization);
        return this;
    }

    public AuthorizeUrl withInvitation(String invitation) {
        this.builder.withInvitation(invitation);
        return this;
    }

    public AuthorizeUrl withConnection(String connection) {
        this.builder.withConnection(connection);
        return this;
    }

    public AuthorizeUrl withSecureCookie(boolean secureCookie) {
        this.setSecureCookie = secureCookie;
        return this;
    }

    AuthorizeUrl withLegacySameSiteCookie(boolean useLegacySameSiteCookie) {
        this.useLegacySameSiteCookie = useLegacySameSiteCookie;
        return this;
    }

    public AuthorizeUrl withAudience(String audience) {
        this.builder.withAudience(audience);
        return this;
    }

    public AuthorizeUrl withState(String state) {
        this.state = state;
        this.builder.withState(state);
        return this;
    }

    public AuthorizeUrl withNonce(String nonce) {
        this.nonce = nonce;
        this.builder.withParameter("nonce", nonce);
        return this;
    }

    public AuthorizeUrl withScope(String scope) {
        this.builder.withScope(scope);
        return this;
    }

    public AuthorizeUrl withParameter(String name, String value) {
        if ("state".equals(name) || "nonce".equals(name)) {
            throw new IllegalArgumentException("Please, use the dedicated methods for setting the 'nonce' and 'state' parameters.");
        }
        if ("response_type".equals(name)) {
            throw new IllegalArgumentException("Response type cannot be changed once set.");
        }
        if ("redirect_uri".equals(name)) {
            throw new IllegalArgumentException("Redirect URI cannot be changed once set.");
        }
        this.builder.withParameter(name, value);
        return this;
    }

    public String build() throws IllegalStateException {
        if (this.used) {
            throw new IllegalStateException("The AuthorizeUrl instance must not be reused.");
        }
        if (this.response != null) {
            SameSite sameSiteValue = this.containsFormPost() ? SameSite.NONE : SameSite.LAX;
            TransientCookieStore.storeState(this.response, this.state, sameSiteValue, this.useLegacySameSiteCookie, this.setSecureCookie);
            TransientCookieStore.storeNonce(this.response, this.nonce, sameSiteValue, this.useLegacySameSiteCookie, this.setSecureCookie);
        }
        RandomStorage.setSessionState(this.request, this.state);
        RandomStorage.setSessionNonce(this.request, this.nonce);
        this.used = true;
        return this.builder.build();
    }

    private boolean containsFormPost() {
        String[] splitResponseTypes = this.responseType.trim().split("\\s+");
        List<String> responseTypes = Collections.unmodifiableList(Arrays.asList(splitResponseTypes));
        return RequestProcessor.requiresFormPostResponseMode(responseTypes);
    }
}

