/*
 * Decompiled with CFR 0.152.
 */
package com.auth0;

import com.auth0.NonceFactory;
import com.auth0.QueryParamUtils;
import com.auth0.SessionUtils;
import javax.servlet.http.HttpServletRequest;

public class NonceUtils {
    public static final String NONCE_KEY = "nonce";

    public static void addNonceToStorage(HttpServletRequest req) {
        String stateFromStorage;
        String string = stateFromStorage = SessionUtils.getState(req) != null ? SessionUtils.getState(req) : "";
        if (!QueryParamUtils.keyInQueryParams(stateFromStorage, NONCE_KEY)) {
            String updatedState = QueryParamUtils.addOrReplaceInQueryParams(stateFromStorage, NONCE_KEY, NonceFactory.create());
            SessionUtils.setState(req, updatedState);
        }
    }

    public static void removeNonceFromStorage(HttpServletRequest req) {
        String stateFromStorage = SessionUtils.getState(req) != null ? SessionUtils.getState(req) : "";
        String stateFromStorageWithoutNonce = QueryParamUtils.removeFromQueryParams(stateFromStorage, NONCE_KEY);
        SessionUtils.setState(req, stateFromStorageWithoutNonce);
    }

    public static boolean matchesNonceInStorage(HttpServletRequest req, String stateFromRequest) {
        String nonceFromRequest = QueryParamUtils.parseFromQueryParams(stateFromRequest, NONCE_KEY);
        String stateFromStorage = SessionUtils.getState(req);
        String nonceFromStorage = QueryParamUtils.parseFromQueryParams(stateFromStorage, NONCE_KEY);
        return nonceFromRequest != null && !nonceFromRequest.isEmpty() && nonceFromRequest.equals(nonceFromStorage);
    }
}

