/*
 * Decompiled with CFR 0.152.
 */
package com.auth0;

import com.auth0.Auth0;
import com.auth0.Auth0Client;
import com.auth0.Auth0User;
import com.auth0.Tokens;
import com.auth0.authentication.AuthenticationAPIClient;
import com.auth0.authentication.result.Credentials;
import com.auth0.authentication.result.UserProfile;
import org.apache.commons.lang3.Validate;

public class Auth0ClientImpl
implements Auth0Client {
    protected final String clientSecret;
    protected final AuthenticationAPIClient authenticationAPIClient;

    public Auth0ClientImpl(String clientId, String clientSecret, String domain) {
        Validate.notNull((Object)clientId);
        Validate.notNull((Object)clientSecret);
        Validate.notNull((Object)domain);
        this.clientSecret = clientSecret;
        Auth0 auth0 = new Auth0(clientId, clientSecret, domain);
        this.authenticationAPIClient = new AuthenticationAPIClient(auth0);
    }

    @Override
    public Tokens getTokens(String authorizationCode, String redirectUri) {
        Validate.notNull((Object)authorizationCode);
        Validate.notNull((Object)redirectUri);
        Credentials creds = this.authenticationAPIClient.token(authorizationCode, redirectUri).setClientSecret(this.clientSecret).execute();
        return new Tokens(creds.getIdToken(), creds.getAccessToken(), creds.getType(), creds.getRefreshToken());
    }

    @Override
    public Auth0User getUserProfile(Tokens tokens) {
        Validate.notNull((Object)tokens);
        String idToken = tokens.getIdToken();
        UserProfile userProfile = (UserProfile)this.authenticationAPIClient.tokenInfo(idToken).execute();
        return new Auth0User(userProfile);
    }
}

