/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.react.bridge;

import android.support.annotation.Nullable;
import android.util.Log;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ShowOptions {
    private static final String TAG = ShowOptions.class.getName();
    private static final String CLOSABLE_KEY = "closable";
    private static final String AUTH_PARAMS_KEY = "authParams";
    private static final String CONNECTIONS_KEY = "connections";
    private static final String USE_MAGIC_LINK_KEY = "useMagicLink";
    private boolean closable = false;
    private boolean useMagicLink = false;
    private Map<String, Object> authParams;
    private String[] connections;
    private String connectionType = "default";

    public ShowOptions(@Nullable ReadableMap options) {
        if (options == null) {
            return;
        }
        if (options.hasKey(CLOSABLE_KEY)) {
            this.closable = options.getBoolean(CLOSABLE_KEY);
            Log.d((String)TAG, (String)(CLOSABLE_KEY + this.closable));
        }
        if (options.hasKey(USE_MAGIC_LINK_KEY)) {
            this.useMagicLink = options.getBoolean(USE_MAGIC_LINK_KEY);
            Log.d((String)TAG, (String)(USE_MAGIC_LINK_KEY + this.useMagicLink));
        }
        if (options.hasKey(AUTH_PARAMS_KEY)) {
            ReadableMap reactMap = options.getMap(AUTH_PARAMS_KEY);
            this.authParams = this.convertReadableMapToMap(reactMap);
            Log.d((String)TAG, (String)(AUTH_PARAMS_KEY + this.authParams));
        }
        if (options.hasKey(CONNECTIONS_KEY)) {
            ReadableArray connections = options.getArray(CONNECTIONS_KEY);
            ArrayList<String> list = new ArrayList<String>(connections.size());
            for (int i = 0; i < connections.size(); ++i) {
                String connectionName;
                switch (connectionName = connections.getString(i)) {
                    case "email": {
                        this.connectionType = "email";
                        break;
                    }
                    case "sms": {
                        this.connectionType = "sms";
                    }
                }
                list.add(connectionName);
            }
            this.connections = new String[list.size()];
            this.connections = list.toArray(this.connections);
            Log.d((String)TAG, (String)(CONNECTIONS_KEY + this.connections));
        }
    }

    private Map<String, Object> convertReadableMapToMap(ReadableMap reactMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReadableMapKeySetIterator keySet = reactMap.keySetIterator();
        while (keySet.hasNextKey()) {
            String key = keySet.nextKey();
            Object object = null;
            switch (reactMap.getType(key)) {
                case Array: {
                    object = this.convertReadableArrayToArray(reactMap.getArray(key));
                    break;
                }
                case Boolean: {
                    object = reactMap.getBoolean(key);
                    break;
                }
                case Map: {
                    object = this.convertReadableMapToMap(reactMap.getMap(key));
                    break;
                }
                case Null: {
                    object = null;
                    break;
                }
                case Number: {
                    try {
                        object = reactMap.getDouble(key);
                    }
                    catch (ClassCastException e) {
                        object = reactMap.getInt(key);
                    }
                    break;
                }
                case String: {
                    object = reactMap.getString(key);
                    break;
                }
                default: {
                    Log.e((String)TAG, (String)("Unknown type: " + reactMap.getType(key) + " for key: " + key));
                }
            }
            map.put(key, object);
        }
        return map;
    }

    private ArrayList convertReadableArrayToArray(ReadableArray reactArray) {
        ArrayList<Map<String, Object>> array = new ArrayList<Map<String, Object>>();
        int size = reactArray.size();
        for (int i = 0; i < size; ++i) {
            Object object = null;
            switch (reactArray.getType(i)) {
                case Array: {
                    object = this.convertReadableArrayToArray(reactArray.getArray(i));
                    break;
                }
                case Boolean: {
                    object = reactArray.getBoolean(i);
                    break;
                }
                case Map: {
                    object = this.convertReadableMapToMap(reactArray.getMap(i));
                    break;
                }
                case Null: {
                    object = null;
                    break;
                }
                case Number: {
                    try {
                        object = reactArray.getDouble(i);
                    }
                    catch (ClassCastException e) {
                        object = reactArray.getInt(i);
                    }
                    break;
                }
                case String: {
                    object = reactArray.getString(i);
                    break;
                }
                default: {
                    Log.e((String)TAG, (String)("Unknown type: " + reactArray.getType(i) + " for index: " + i));
                }
            }
            array.add((Map<String, Object>)object);
        }
        return array;
    }

    public boolean isClosable() {
        return this.closable;
    }

    public boolean useMagicLink() {
        return this.useMagicLink;
    }

    public Map<String, Object> getAuthParams() {
        return this.authParams;
    }

    public String[] getConnections() {
        return this.connections;
    }

    public String getConnectionType() {
        return this.connectionType;
    }
}

