/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.lock.react.bridge;

import android.support.annotation.Nullable;
import com.auth0.core.UserProfile;
import com.auth0.lock.react.bridge.LockReactBridge;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

public class UserProfileBridge
implements LockReactBridge {
    private static final String EMAIL_KEY = "email";
    private static final String ID_KEY = "id";
    private static final String NAME_KEY = "name";
    private static final String NICKNAME_KEY = "nickname";
    private static final String CREATED_AT_KEY = "createdAt";
    private UserProfile profile;

    public UserProfileBridge(@Nullable UserProfile profile) {
        this.profile = profile;
    }

    @Override
    public WritableMap toMap() {
        WritableMap profileMap = null;
        if (this.profile != null) {
            profileMap = Arguments.createMap();
            profileMap.putString(EMAIL_KEY, this.profile.getEmail());
            profileMap.putString(ID_KEY, this.profile.getId());
            profileMap.putString(NAME_KEY, this.profile.getName());
            profileMap.putString(NICKNAME_KEY, this.profile.getNickname());
            if (this.profile.getCreatedAt() != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                profileMap.putString(CREATED_AT_KEY, simpleDateFormat.format(this.profile.getCreatedAt()));
            }
        }
        return profileMap;
    }
}

