/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.android.jwt;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.auth0.android.jwt.Claim;
import com.auth0.android.jwt.DecodeException;
import com.auth0.android.jwt.JWTDeserializer;
import com.auth0.android.jwt.JWTPayload;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class JWT
implements Parcelable {
    private static final String TAG = JWT.class.getSimpleName();
    private static final String ENCODING_UTF_8 = "UTF-8";
    private final String token;
    private Map<String, String> header;
    private JWTPayload payload;
    private String signature;
    public static final Parcelable.Creator<JWT> CREATOR = new Parcelable.Creator<JWT>(){

        public JWT createFromParcel(Parcel in) {
            return new JWT(in.readString());
        }

        public JWT[] newArray(int size) {
            return new JWT[size];
        }
    };

    public JWT(@NonNull String token) {
        this.decode(token);
        this.token = token;
    }

    @NonNull
    public Map<String, String> getHeader() {
        return this.header;
    }

    @NonNull
    public String getSignature() {
        return this.signature;
    }

    @Nullable
    public String getIssuer() {
        return this.payload.iss;
    }

    @Nullable
    public String getSubject() {
        return this.payload.sub;
    }

    @Nullable
    public List<String> getAudience() {
        return this.payload.aud;
    }

    @Nullable
    public Date getExpiresAt() {
        return this.payload.exp;
    }

    @Nullable
    public Date getNotBefore() {
        return this.payload.nbf;
    }

    @Nullable
    public Date getIssuedAt() {
        return this.payload.iat;
    }

    @Nullable
    public String getId() {
        return this.payload.jti;
    }

    @NonNull
    public Claim getClaim(@NonNull String name) {
        return this.payload.claimForName(name);
    }

    @NonNull
    public Map<String, Claim> getClaims() {
        return this.payload.tree;
    }

    public boolean isExpired(long leeway) {
        if (leeway < 0L) {
            throw new IllegalArgumentException("The leeway must be a positive value.");
        }
        long todayTime = (long)(Math.floor(new Date().getTime() / 1000L) * 1000.0);
        Date futureToday = new Date(todayTime + leeway * 1000L);
        Date pastToday = new Date(todayTime - leeway * 1000L);
        boolean expValid = this.payload.exp == null || !pastToday.after(this.payload.exp);
        boolean iatValid = this.payload.iat == null || !futureToday.before(this.payload.iat);
        return !expValid || !iatValid;
    }

    public String toString() {
        return this.token;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.token);
    }

    private void decode(String token) {
        String[] parts = this.splitToken(token);
        Type mapType = new TypeToken<Map<String, String>>(){}.getType();
        this.header = (Map)this.parseJson(this.base64Decode(parts[0]), mapType);
        this.payload = (JWTPayload)this.parseJson(this.base64Decode(parts[1]), (Type)((Object)JWTPayload.class));
        this.signature = parts[2];
    }

    private String[] splitToken(String token) {
        String[] parts = token.split("\\.");
        if (parts.length == 2 && token.endsWith(".")) {
            parts = new String[]{parts[0], parts[1], ""};
        }
        if (parts.length != 3) {
            throw new DecodeException(String.format("The token was expected to have 3 parts, but got %s.", parts.length));
        }
        return parts;
    }

    @Nullable
    private String base64Decode(String string) {
        String decoded;
        try {
            byte[] bytes = Base64.decode((String)string, (int)11);
            decoded = new String(bytes, ENCODING_UTF_8);
        }
        catch (IllegalArgumentException e) {
            throw new DecodeException("Received bytes didn't correspond to a valid Base64 encoded string.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new DecodeException("Device doesn't support UTF-8 charset encoding.", e);
        }
        return decoded;
    }

    private <T> T parseJson(String json, Type typeOfT) {
        Object payload;
        try {
            payload = JWT.getGson().fromJson(json, typeOfT);
        }
        catch (Exception e) {
            throw new DecodeException("The token's payload had an invalid JSON format.", e);
        }
        return (T)payload;
    }

    static Gson getGson() {
        return new GsonBuilder().registerTypeAdapter(JWTPayload.class, (Object)new JWTDeserializer()).create();
    }
}

