/*
 * Decompiled with CFR 0.152.
 */
package com.austingreco.imagelistpreference;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.preference.ListPreference;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.RadioButton;
import android.widget.TextView;
import com.austingreco.imagelistpreference.R;
import java.util.ArrayList;
import java.util.List;

public class ImageListPreference
extends ListPreference {
    private static final String TAG = "ImageListPreference";
    private static final int DEFAULT_TINT = -16777216;
    private static final int DEFAULT_BACKGROUND_TINT = -1;
    private int mErrorResource;
    private List<Integer> mImages = new ArrayList<Integer>();
    private int mTintColor;
    private int mBackgroundColor;
    private boolean mUseCard;
    private int mCustomItemLayout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageListPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.getContext());
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.ImageListPreference);
        try {
            int entryImagesArrayResource = array.getResourceId(R.styleable.ImageListPreference_ilp_entryImages, 0);
            String tintKey = array.getNonResourceString(R.styleable.ImageListPreference_ilp_tintKey);
            String backgroundKey = array.getNonResourceString(R.styleable.ImageListPreference_ilp_backgroundTint);
            this.mTintColor = array.getColor(R.styleable.ImageListPreference_ilp_tint, -16777216);
            this.mBackgroundColor = array.getColor(R.styleable.ImageListPreference_ilp_backgroundTint, 0);
            this.mErrorResource = array.getResourceId(R.styleable.ImageListPreference_ilp_errorImage, 0);
            this.mUseCard = array.getBoolean(R.styleable.ImageListPreference_ilp_useCard, false);
            this.mCustomItemLayout = array.getResourceId(R.styleable.ImageListPreference_ilp_itemLayout, 0);
            if (tintKey != null) {
                this.mTintColor = sharedPreferences.getInt(tintKey, this.mTintColor);
            }
            if (backgroundKey != null) {
                this.mBackgroundColor = sharedPreferences.getInt(backgroundKey, this.mBackgroundColor);
            }
            TypedArray images = context.getResources().obtainTypedArray(entryImagesArrayResource);
            for (int i = 0; i < images.length(); ++i) {
                this.mImages.add(images.getResourceId(i, 0));
            }
            images.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            array.recycle();
        }
    }

    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        ArrayList<ImageListItem> items = new ArrayList<ImageListItem>();
        int length = this.getEntries().length;
        for (int i = 0; i < length; ++i) {
            int resource = 0;
            if (this.mImages.size() > i) {
                resource = this.mImages.get(i);
            }
            items.add(new ImageListItem(this.getEntries()[i], resource, this.getEntryValues()[i].equals(this.getValue())));
        }
        int layout2 = R.layout.imagelistpreference_item;
        if (this.mUseCard) {
            layout2 = R.layout.imagelistpreference_item_card;
        }
        if (this.mCustomItemLayout != 0) {
            layout2 = this.mCustomItemLayout;
        }
        ImageListPreferenceAdapter adapter = new ImageListPreferenceAdapter(this.getContext(), layout2, items);
        builder.setAdapter((ListAdapter)adapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ImageListPreference.super.onClick(dialog, which);
            }
        });
        super.onPrepareDialogBuilder(builder);
    }

    private class ViewHolder {
        ImageView iconImage;
        TextView iconName;
        RadioButton radioButton;

        private ViewHolder() {
        }
    }

    private class ImageListItem {
        private int resource;
        private boolean isChecked;
        private String name;

        ImageListItem(CharSequence name, int resource, boolean isChecked) {
            this(name.toString(), resource, isChecked);
        }

        ImageListItem(String name, int resource, boolean isChecked) {
            this.name = name;
            this.resource = resource;
            this.isChecked = isChecked;
        }
    }

    private class ImageListPreferenceAdapter
    extends ArrayAdapter<ImageListItem> {
        private List<ImageListItem> mItems;
        private int mLayoutResource;

        ImageListPreferenceAdapter(Context context, int layoutResource, List<ImageListItem> items) {
            super(context, layoutResource, items);
            this.mLayoutResource = layoutResource;
            this.mItems = items;
        }

        @NonNull
        public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
            ViewHolder holder;
            if (convertView == null) {
                LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
                try {
                    assert (inflater != null);
                    convertView = inflater.inflate(this.mLayoutResource, parent, false);
                    holder = new ViewHolder();
                    holder.iconName = (TextView)convertView.findViewById(R.id.imagelistpreference_text);
                    holder.iconImage = (ImageView)convertView.findViewById(R.id.imagelistpreference_image);
                    holder.radioButton = (RadioButton)convertView.findViewById(R.id.imagelistpreference_radio);
                    convertView.setTag((Object)holder);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return super.getView(position, null, parent);
                }
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            if (holder == null) {
                return super.getView(position, convertView, parent);
            }
            ImageListItem item = this.mItems.get(position);
            holder.iconName.setText((CharSequence)item.name);
            if (item.resource != 0) {
                holder.iconImage.setImageResource(item.resource);
            } else {
                holder.iconImage.setImageResource(ImageListPreference.this.mErrorResource);
            }
            if (ImageListPreference.this.mTintColor != 0) {
                holder.iconImage.setColorFilter(ImageListPreference.this.mTintColor);
            }
            if (ImageListPreference.this.mBackgroundColor != 0) {
                holder.iconImage.setBackgroundColor(ImageListPreference.this.mBackgroundColor);
            }
            holder.radioButton.setChecked(item.isChecked);
            return convertView;
        }
    }
}

