/*
 * Decompiled with CFR 0.152.
 */
package com.augustopicciani.drawablepageindicator.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import com.augustopicciani.drawablepageindicator.R;
import com.augustopicciani.drawablepageindicator.interfaces.PageIndicator;

public class DrawablePagerIndicator
extends View
implements PageIndicator {
    private int imageSpacing;
    private int drawableDefaultId;
    private int drawableSelectedId;
    private ViewPager mViewPager;
    private ViewPager.OnPageChangeListener mListener;
    private Context mContext;
    private int mCurrentPage = 0;
    private boolean mCentered;

    public DrawablePagerIndicator(Context context) {
        super(context);
        this.mContext = context;
    }

    public DrawablePagerIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DrawablePagerIndicator, 0, 0);
        this.drawableSelectedId = a.getResourceId(R.styleable.DrawablePagerIndicator_drawableSelected, R.drawable.ic_slider_on);
        this.drawableDefaultId = a.getResourceId(R.styleable.DrawablePagerIndicator_drawableDefault, R.drawable.ic_slider_off);
        this.imageSpacing = a.getInteger(R.styleable.DrawablePagerIndicator_imageSpacing, 0);
        this.mCentered = a.getBoolean(R.styleable.DrawablePagerIndicator_centered, false);
        a.recycle();
    }

    public DrawablePagerIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DrawablePagerIndicator, defStyleAttr, 0);
        this.drawableSelectedId = a.getResourceId(R.styleable.DrawablePagerIndicator_drawableSelected, R.drawable.ic_slider_on);
        this.drawableDefaultId = a.getResourceId(R.styleable.DrawablePagerIndicator_drawableDefault, R.drawable.ic_slider_off);
        this.imageSpacing = a.getInteger(R.styleable.DrawablePagerIndicator_imageSpacing, 0);
        this.mCentered = a.getBoolean(R.styleable.DrawablePagerIndicator_centered, false);
        a.recycle();
    }

    @TargetApi(value=21)
    public DrawablePagerIndicator(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DrawablePagerIndicator, defStyleAttr, 0);
        this.drawableSelectedId = a.getResourceId(R.styleable.DrawablePagerIndicator_drawableSelected, R.drawable.ic_slider_on);
        this.drawableDefaultId = a.getResourceId(R.styleable.DrawablePagerIndicator_drawableDefault, R.drawable.ic_slider_off);
        this.imageSpacing = a.getInteger(R.styleable.DrawablePagerIndicator_imageSpacing, 0);
        a.recycle();
    }

    public void setDrawableDefaultId(int drawableDefaultId) {
        this.drawableDefaultId = drawableDefaultId;
    }

    public void setDrawableSelectedId(int drawableSelectedId) {
        this.drawableSelectedId = drawableSelectedId;
    }

    public void setCentered(boolean centered) {
        this.mCentered = centered;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mViewPager == null) {
            return;
        }
        int count = this.mViewPager.getAdapter().getCount();
        if (count == 0) {
            return;
        }
        if (this.mCurrentPage >= count) {
            this.setCurrentItem(count - 1);
            return;
        }
        float dx = -1.0f;
        Bitmap imageChildDefault = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)this.drawableDefaultId);
        Bitmap imageChildSelected = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)this.drawableSelectedId);
        int imageSize = imageChildDefault.getWidth();
        int canvasWidth = canvas.getWidth();
        int circlesWith = imageSize * count + this.imageSpacing * (count - 1);
        int startingPoint = (canvasWidth - circlesWith) / 2;
        for (int i = 0; i < count; ++i) {
            if (i == 0) {
                dx = 0.0f;
            }
            if (this.mCentered) {
                dx = startingPoint + i * (imageSize + this.imageSpacing);
            }
            Bitmap imageToDraw = this.mCurrentPage == i ? imageChildSelected : imageChildDefault;
            canvas.drawBitmap(imageToDraw, dx, 0.0f, null);
            if (this.mCentered) continue;
            dx += (float)(imageChildDefault.getWidth() + this.imageSpacing);
        }
    }

    @Override
    public void setViewPager(ViewPager view) {
        if (this.mViewPager == view) {
            return;
        }
        if (this.mViewPager != null) {
            this.mViewPager.setOnPageChangeListener(null);
        }
        if (view.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.mViewPager = view;
        this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.invalidate();
    }

    @Override
    public void setViewPager(ViewPager view, int initialPosition) {
        this.setViewPager(view);
        this.setCurrentItem(initialPosition);
    }

    @Override
    public void setCurrentItem(int item) {
        if (this.mViewPager == null) {
            throw new IllegalStateException("ViewPager has not been bound.");
        }
        this.mViewPager.setCurrentItem(item);
        this.mCurrentPage = item;
        this.invalidate();
    }

    @Override
    public void notifyDataSetChanged() {
        this.invalidate();
    }

    public void onPageScrollStateChanged(int state) {
        if (this.mListener != null) {
            this.mListener.onPageScrollStateChanged(state);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        this.mCurrentPage = position;
        this.invalidate();
        if (this.mListener != null) {
            this.mListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        if (this.mListener != null) {
            this.mListener.onPageSelected(position);
        }
    }

    @Override
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }
}

