/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.AlgorithmID;
import COSE.CoseException;
import COSE.HeaderKeys;
import COSE.MacCommon;
import COSE.MessageTag;
import COSE.Recipient;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.crypto.InvalidCipherTextException;

public class MACMessage
extends MacCommon {
    protected List<Recipient> recipientList = new ArrayList<Recipient>();

    public MACMessage() {
        this.strContext = "MAC";
        this.messageTag = MessageTag.MAC;
    }

    public void addRecipient(Recipient recipient) throws CoseException {
        if (recipient == null) {
            throw new CoseException("Recipient is null");
        }
        this.recipientList.add(recipient);
    }

    public Recipient getRecipient(int iRecipient) {
        return this.recipientList.get(iRecipient);
    }

    public int getRecipientCount() {
        return this.recipientList.size();
    }

    public List<Recipient> getRecipientList() {
        return this.recipientList;
    }

    @Override
    public void DecodeFromCBORObject(CBORObject obj) throws CoseException {
        if (obj.size() != 5) {
            throw new CoseException("Invalid MAC structure");
        }
        if (obj.get(0).getType() == CBORType.ByteString) {
            this.objProtected = obj.get(0).GetByteString().length == 0 ? CBORObject.NewMap() : CBORObject.DecodeFromBytes((byte[])obj.get(0).GetByteString());
        } else {
            throw new CoseException("Invalid MAC structure");
        }
        if (obj.get(1).getType() != CBORType.Map) {
            throw new CoseException("Invalid MAC structure");
        }
        this.objUnprotected = obj.get(1);
        if (obj.get(2).getType() == CBORType.ByteString) {
            this.rgbContent = obj.get(2).GetByteString();
        } else if (!obj.get(2).isNull()) {
            throw new CoseException("Invalid MAC structure");
        }
        if (obj.get(3).getType() != CBORType.ByteString) {
            throw new CoseException("Invalid MAC structure");
        }
        this.rgbTag = obj.get(3).GetByteString();
        if (obj.get(4).getType() == CBORType.Array) {
            for (int i = 0; i < obj.get(4).size(); ++i) {
                Recipient recipient = new Recipient();
                recipient.DecodeFromCBORObject(obj.get(4).get(i));
                this.recipientList.add(recipient);
            }
        } else {
            throw new CoseException("Invalid MAC structure");
        }
    }

    @Override
    protected CBORObject EncodeCBORObject() throws CoseException {
        if (this.rgbTag == null) {
            throw new CoseException("Compute function not called");
        }
        CBORObject obj = CBORObject.NewArray();
        if (this.objProtected.size() > 0) {
            obj.Add((Object)this.objProtected.EncodeToBytes());
        } else {
            obj.Add(CBORObject.FromObject((byte[])new byte[0]));
        }
        obj.Add(this.objUnprotected);
        obj.Add((Object)this.rgbContent);
        obj.Add((Object)this.rgbTag);
        CBORObject cnRecipients = CBORObject.NewArray();
        for (Recipient r : this.recipientList) {
            cnRecipients.Add(r.EncodeCBORObject());
        }
        obj.Add(cnRecipients);
        return obj;
    }

    public boolean Validate(Recipient recipientToUse) throws CoseException, InvalidCipherTextException {
        byte[] rgbKey = null;
        boolean cbitKey = false;
        AlgorithmID alg = AlgorithmID.FromCBOR(this.findAttribute(HeaderKeys.Algorithm));
        for (Recipient recipient : this.recipientList) {
            if (recipientToUse == null) {
                try {
                    rgbKey = recipient.decrypt(alg, recipientToUse);
                }
                catch (CoseException coseException) {}
            } else if (recipientToUse == recipient) {
                try {
                    rgbKey = recipient.decrypt(alg, recipientToUse);
                }
                catch (CoseException coseException) {
                    // empty catch block
                }
                if (rgbKey == null) break;
            }
            if (rgbKey == null) continue;
            return super.Validate(rgbKey);
        }
        throw new CoseException("Usable recipient not found");
    }

    public void Create() throws CoseException, IllegalStateException, InvalidCipherTextException, Exception {
        AlgorithmID alg = AlgorithmID.FromCBOR(this.findAttribute(HeaderKeys.Algorithm));
        byte[] rgbKey = null;
        int recipientTypes = 0;
        if (this.recipientList.isEmpty()) {
            throw new CoseException("No recipients supplied");
        }
        block3: for (Recipient r : this.recipientList) {
            switch (r.getRecipientType()) {
                case 1: {
                    if ((recipientTypes & 1) != 0) {
                        throw new CoseException("Cannot have two direct recipients");
                    }
                    recipientTypes |= 1;
                    rgbKey = r.getKey(alg);
                    continue block3;
                }
            }
            recipientTypes |= 2;
        }
        if (recipientTypes == 3) {
            throw new CoseException("Do not mix direct and indirect recipients");
        }
        if (recipientTypes == 2) {
            rgbKey = new byte[alg.getKeySize() / 8];
            this.random.nextBytes(rgbKey);
        }
        super.CreateWithKey(rgbKey);
        for (Recipient r : this.recipientList) {
            r.SetContent(rgbKey);
            r.encrypt();
        }
    }
}

