/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.AlgorithmID;
import COSE.CoseException;
import COSE.KeyKeys;
import COSE.OneKey;
import com.upokecenter.cbor.CBORType;
import java.math.BigInteger;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.bouncycastle.asn1.x9.X9ECParameters;

public class ECPublicKey
implements java.security.interfaces.ECPublicKey {
    ECPoint point;
    String algorithm;
    ECParameterSpec ecParameterSpec;

    public ECPublicKey(OneKey oneKey) throws CoseException {
        X9ECParameters p = oneKey.GetCurve();
        if (oneKey.get(KeyKeys.EC2_Y).getType() == CBORType.Boolean) {
            byte[] X = oneKey.get(KeyKeys.EC2_X.AsCBOR()).GetByteString();
            byte[] rgb = new byte[X.length + 1];
            System.arraycopy(X, 0, rgb, 1, X.length);
            rgb[0] = (byte)(2 + (oneKey.get(KeyKeys.EC2_Y).AsBoolean() ? 1 : 0));
            org.bouncycastle.math.ec.ECPoint pubPoint = p.getCurve().decodePoint(rgb);
            this.point = new ECPoint(this.point.getAffineX(), this.point.getAffineY());
        } else {
            this.point = new ECPoint(new BigInteger(1, oneKey.get(KeyKeys.EC2_X).GetByteString()), new BigInteger(1, oneKey.get(KeyKeys.EC2_Y).GetByteString()));
        }
        switch (AlgorithmID.FromCBOR(oneKey.get(KeyKeys.Algorithm))) {
            case ECDH_ES_HKDF_256: 
            case ECDH_ES_HKDF_512: 
            case ECDH_SS_HKDF_256: 
            case ECDH_SS_HKDF_512: 
            case ECDH_ES_HKDF_256_AES_KW_128: 
            case ECDH_ES_HKDF_256_AES_KW_192: 
            case ECDH_ES_HKDF_256_AES_KW_256: 
            case ECDH_SS_HKDF_256_AES_KW_128: 
            case ECDH_SS_HKDF_256_AES_KW_192: 
            case ECDH_SS_HKDF_256_AES_KW_256: {
                this.algorithm = "ECDH";
                break;
            }
            case ECDSA_256: {
                this.algorithm = "SHA256withECDSA";
                break;
            }
            case ECDSA_384: {
                this.algorithm = "SHA384withECDSA";
                break;
            }
            case ECDSA_512: {
                this.algorithm = "SHA512withECDSA";
                break;
            }
            default: {
                throw new CoseException("No algorithm specified");
            }
        }
        ECFieldFp field = new ECFieldFp(p.getCurve().getField().getCharacteristic());
        EllipticCurve crv = new EllipticCurve(field, p.getCurve().getA().toBigInteger(), p.getCurve().getB().toBigInteger());
        ECPoint pt = new ECPoint(p.getG().getRawXCoord().toBigInteger(), p.getG().getRawYCoord().toBigInteger());
        this.ecParameterSpec = new ECParameterSpec(crv, pt, p.getN(), p.getH().intValue());
    }

    @Override
    public ECPoint getW() {
        return this.point;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.ecParameterSpec;
    }
}

