/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.CoseException;
import COSE.MessageTag;
import COSE.SignCommon;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import org.bouncycastle.crypto.CipherParameters;

public class Sign1Message
extends SignCommon {
    byte[] rgbSignature;

    public Sign1Message() {
        this(true);
    }

    public Sign1Message(boolean emitTag) {
        this.emitTag = emitTag;
        this.contextString = "Signature1";
        this.messageTag = MessageTag.Sign1;
    }

    public void sign(CBORObject cnKey) throws CoseException {
        if (this.rgbContent == null) {
            throw new CoseException("No Content Specified");
        }
        CBORObject obj = CBORObject.NewArray();
        obj.Add((Object)this.contextString);
        if (this.objProtected.size() > 0) {
            obj.Add((Object)this.objProtected.EncodeToBytes());
        } else {
            obj.Add(CBORObject.FromObject((byte[])new byte[0]));
        }
        obj.Add((Object)this.externalData);
        obj.Add((Object)this.rgbContent);
        this.rgbSignature = this.computeSignature(obj.EncodeToBytes(), cnKey);
    }

    public void sign(CipherParameters key) throws CoseException {
        if (this.rgbContent == null) {
            throw new CoseException("No Content Specified");
        }
        CBORObject obj = CBORObject.NewArray();
        obj.Add((Object)this.contextString);
        if (this.objProtected.size() > 0) {
            obj.Add((Object)this.objProtected.EncodeToBytes());
        } else {
            obj.Add(CBORObject.FromObject((byte[])new byte[0]));
        }
        obj.Add((Object)this.externalData);
        obj.Add((Object)this.rgbContent);
        this.rgbSignature = this.computeSignature(obj.EncodeToBytes(), key);
    }

    public boolean validate(CBORObject cnKey) throws CoseException {
        CBORObject obj = CBORObject.NewArray();
        obj.Add((Object)this.contextString);
        if (this.objProtected.size() > 0) {
            obj.Add((Object)this.rgbProtected);
        } else {
            obj.Add(CBORObject.FromObject((byte[])new byte[0]));
        }
        obj.Add((Object)this.externalData);
        obj.Add((Object)this.rgbContent);
        return this.validateSignature(obj.EncodeToBytes(), this.rgbSignature, cnKey);
    }

    public boolean validate(CipherParameters key) throws CoseException {
        CBORObject obj = CBORObject.NewArray();
        obj.Add((Object)this.contextString);
        if (this.objProtected.size() > 0) {
            obj.Add((Object)this.rgbProtected);
        } else {
            obj.Add(CBORObject.FromObject((byte[])new byte[0]));
        }
        obj.Add((Object)this.externalData);
        obj.Add((Object)this.rgbContent);
        return this.validateSignature(obj.EncodeToBytes(), this.rgbSignature, key);
    }

    @Override
    protected void DecodeFromCBORObject(CBORObject messageObject) throws CoseException {
        if (messageObject.size() != 4) {
            throw new CoseException("Invalid Sign1 structure");
        }
        if (messageObject.get(0).getType() == CBORType.ByteString) {
            if (messageObject.get(0).GetByteString().length == 0) {
                this.objProtected = CBORObject.NewMap();
            } else {
                this.rgbProtected = messageObject.get(0).GetByteString();
                this.objProtected = CBORObject.DecodeFromBytes((byte[])this.rgbProtected);
            }
        } else {
            throw new CoseException("Invalid Sign1 structure");
        }
        if (messageObject.get(1).getType() != CBORType.Map) {
            throw new CoseException("Invalid Sign1 structure");
        }
        this.objUnprotected = messageObject.get(1);
        if (messageObject.get(2).getType() == CBORType.ByteString) {
            this.rgbContent = messageObject.get(2).GetByteString();
        } else if (!messageObject.get(2).isNull()) {
            throw new CoseException("Invalid Sign1 structure");
        }
        if (messageObject.get(3).getType() != CBORType.ByteString) {
            throw new CoseException("Invalid Sign1 structure");
        }
        this.rgbSignature = messageObject.get(3).GetByteString();
    }

    @Override
    protected CBORObject EncodeCBORObject() throws CoseException {
        if (this.rgbSignature == null) {
            throw new CoseException("sign function not called");
        }
        CBORObject obj = CBORObject.NewArray();
        if (this.objProtected.size() > 0) {
            obj.Add((Object)this.objProtected.EncodeToBytes());
        } else {
            obj.Add(CBORObject.FromObject((byte[])new byte[0]));
        }
        obj.Add(this.objUnprotected);
        obj.Add((Object)this.rgbContent);
        obj.Add((Object)this.rgbSignature);
        return obj;
    }
}

