/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.AlgorithmID;
import COSE.CoseException;
import COSE.Message;
import com.upokecenter.cbor.CBORObject;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.macs.CBCBlockCipherMac;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public abstract class MacCommon
extends Message {
    protected byte[] rgbTag;
    protected String strContext;
    protected SecureRandom random = new SecureRandom();

    protected MacCommon() {
    }

    protected void CreateWithKey(byte[] rgbKey) throws CoseException {
        CBORObject algX = this.findAttribute(CBORObject.FromObject((int)1));
        AlgorithmID alg = AlgorithmID.FromCBOR(algX);
        if (this.rgbContent == null) {
            throw new CoseException("No Content Specified");
        }
        switch (alg) {
            case HMAC_SHA_256_64: 
            case HMAC_SHA_256: 
            case HMAC_SHA_384: 
            case HMAC_SHA_512: {
                this.rgbTag = this.HMAC(alg, rgbKey);
                break;
            }
            case AES_CBC_MAC_128_64: 
            case AES_CBC_MAC_128_128: 
            case AES_CBC_MAC_256_64: 
            case AES_CBC_MAC_256_128: {
                this.rgbTag = this.AES_CBC_MAC(alg, rgbKey);
                break;
            }
            default: {
                throw new CoseException("Unsupported MAC Algorithm");
            }
        }
    }

    protected boolean Validate(byte[] rgbKey) throws CoseException {
        byte[] rgbTest;
        CBORObject algX = this.findAttribute(CBORObject.FromObject((int)1));
        AlgorithmID alg = AlgorithmID.FromCBOR(algX);
        switch (alg) {
            case HMAC_SHA_256_64: 
            case HMAC_SHA_256: 
            case HMAC_SHA_384: 
            case HMAC_SHA_512: {
                rgbTest = this.HMAC(alg, rgbKey);
                break;
            }
            case AES_CBC_MAC_128_64: 
            case AES_CBC_MAC_128_128: 
            case AES_CBC_MAC_256_64: 
            case AES_CBC_MAC_256_128: {
                rgbTest = this.AES_CBC_MAC(alg, rgbKey);
                break;
            }
            default: {
                throw new CoseException("Unsupported MAC Algorithm");
            }
        }
        if (rgbTest.length != this.rgbTag.length) {
            return false;
        }
        boolean f = true;
        for (int i = 0; i < rgbTest.length; ++i) {
            f &= rgbTest[i] == this.rgbTag[i];
        }
        return f;
    }

    private byte[] BuildContentBytes() {
        CBORObject obj = CBORObject.NewArray();
        obj.Add((Object)this.strContext);
        if (this.objProtected.size() > 0) {
            obj.Add((Object)this.objProtected.EncodeToBytes());
        } else {
            obj.Add(CBORObject.FromObject((byte[])new byte[0]));
        }
        if (this.externalData != null) {
            obj.Add(CBORObject.FromObject((byte[])this.externalData));
        } else {
            obj.Add(CBORObject.FromObject((byte[])new byte[0]));
        }
        obj.Add((Object)this.rgbContent);
        return obj.EncodeToBytes();
    }

    protected byte[] AES_CBC_MAC(AlgorithmID alg, byte[] rgbKey) throws CoseException {
        AESFastEngine aes = new AESFastEngine();
        byte[] IV = new byte[16];
        CBCBlockCipherMac mac = new CBCBlockCipherMac((BlockCipher)aes, alg.getTagSize(), null);
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Key is incorrectly sized");
        }
        KeyParameter ContentKey = new KeyParameter(rgbKey);
        mac.init((CipherParameters)ContentKey);
        byte[] toDigest = this.BuildContentBytes();
        byte[] C = new byte[16];
        mac.update(toDigest, 0, toDigest.length);
        mac.doFinal(C, 0);
        byte[] rgbResult = new byte[alg.getTagSize() / 8];
        System.arraycopy(C, 0, rgbResult, 0, alg.getTagSize() / 8);
        return rgbResult;
    }

    private byte[] HMAC(AlgorithmID alg, byte[] rgbKey) throws CoseException {
        SHA256Digest digest;
        switch (alg) {
            case HMAC_SHA_256_64: {
                digest = new SHA256Digest();
                break;
            }
            case HMAC_SHA_256: {
                digest = new SHA256Digest();
                break;
            }
            case HMAC_SHA_384: {
                digest = new SHA384Digest();
                break;
            }
            case HMAC_SHA_512: {
                digest = new SHA512Digest();
                break;
            }
            default: {
                throw new CoseException("Internal Error");
            }
        }
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Key is incorrect size");
        }
        HMac hmac = new HMac((Digest)digest);
        KeyParameter key = new KeyParameter(rgbKey);
        byte[] toDigest = this.BuildContentBytes();
        byte[] resBuf = new byte[hmac.getMacSize()];
        hmac.init((CipherParameters)key);
        hmac.update(toDigest, 0, toDigest.length);
        hmac.doFinal(resBuf, 0);
        byte[] returnVal = new byte[alg.getTagSize() / 8];
        System.arraycopy(resBuf, 0, returnVal, 0, alg.getTagSize() / 8);
        return returnVal;
    }
}

