/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMEnterListener;
import com.atomikos.icatch.CompositeCoordinator;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Extent;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.imp.AbstractCompositeTransaction;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.TransactionServiceImp;
import com.atomikos.icatch.imp.TransactionStateHandler;
import com.atomikos.icatch.imp.TxActiveStateHandler;
import com.atomikos.icatch.imp.TxTerminatedStateHandler;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.TxState;
import java.util.Map;
import java.util.Stack;

class CompositeTransactionImp
extends AbstractCompositeTransaction
implements FSMEnterListener {
    private static final long serialVersionUID = 975317723773209940L;
    private static final Logger LOGGER = LoggerFactory.createLogger(CompositeTransactionImp.class);
    private CoordinatorImp coordinator = null;
    private TransactionServiceImp txservice;
    private Extent extent = null;
    protected boolean noLocalAncestors;
    private TransactionStateHandler stateHandler;

    CompositeTransactionImp(Stack<CompositeTransaction> lineage, String tid, boolean serial, CoordinatorImp coordinator) {
        this(null, lineage, tid, serial, coordinator);
    }

    CompositeTransactionImp(TransactionServiceImp txservice, Stack<CompositeTransaction> lineage, String tid, boolean serial, CoordinatorImp coordinator) throws IllegalStateException {
        super(tid, lineage, serial);
        this.coordinator = coordinator;
        this.txservice = txservice;
        this.extent = null;
        this.noLocalAncestors = true;
        this.stateHandler = new TxActiveStateHandler(this);
        coordinator.addFSMEnterListener(this, TxState.TERMINATED);
    }

    synchronized void localSetTransactionStateHandler(TransactionStateHandler handler) {
        this.stateHandler = handler;
    }

    synchronized void localTestAndSetTransactionStateHandler(TransactionStateHandler expected, TransactionStateHandler newHandler) {
        if (this.stateHandler != expected) {
            throw new IllegalStateException("State is no longer " + expected.getState() + " but " + newHandler.getState());
        }
        this.localSetTransactionStateHandler(newHandler);
    }

    synchronized TransactionStateHandler localGetTransactionStateHandler() {
        return this.stateHandler;
    }

    boolean isLocalRoot() {
        return this.noLocalAncestors;
    }

    TransactionServiceImp getTransactionService() {
        return this.txservice;
    }

    CoordinatorImp getCoordinatorImp() {
        return this.coordinator;
    }

    @Override
    public synchronized void setSerial() throws IllegalStateException, SysException {
        if (!this.isRoot()) {
            throw new IllegalStateException("Not a root tx.");
        }
        this.serial_ = true;
    }

    @Override
    public CompositeTransaction createSubTransaction() throws SysException, IllegalStateException {
        CompositeTransaction ret = this.localGetTransactionStateHandler().createSubTransaction();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("createSubTransaction(): created new SUBTRANSACTION " + ret.getTid() + " for existing transaction " + this.getTid() + " with coordinatorId " + ret.getCompositeCoordinator().getCoordinatorId());
        }
        return ret;
    }

    @Override
    public RecoveryCoordinator addParticipant(Participant participant) throws SysException, IllegalStateException {
        RecoveryCoordinator ret = this.localGetTransactionStateHandler().addParticipant(participant);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("addParticipant ( " + participant + " ) for transaction " + this.getTid());
        }
        return ret;
    }

    @Override
    public void registerSynchronization(Synchronization sync) throws IllegalStateException, UnsupportedOperationException, SysException {
        this.localGetTransactionStateHandler().registerSynchronization(sync);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("registerSynchronization ( " + sync + " ) for transaction " + this.getTid());
        }
    }

    @Override
    public void addSubTxAwareParticipant(SubTxAwareParticipant subtxaware) throws SysException, IllegalStateException {
        this.localGetTransactionStateHandler().addSubTxAwareParticipant(subtxaware);
    }

    protected void doRollback() throws IllegalStateException, SysException {
        this.localGetTransactionStateHandler().rollbackWithStateCheck();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("rollback() done of transaction " + this.getTid());
        }
    }

    @Override
    public CompositeCoordinator getCompositeCoordinator() throws SysException {
        return this.coordinator;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    protected void doCommit() throws SysException, IllegalStateException, RollbackException {
        this.localGetTransactionStateHandler().commit();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("commit() done (by application) of transaction " + this.getTid());
        }
    }

    @Override
    public long getTimeout() {
        return this.coordinator.getTimeOut();
    }

    @Override
    public synchronized Extent getExtent() {
        if (this.extent == null) {
            if (this.isRoot()) {
                this.extent = new Extent();
            } else {
                String parentTransactionId = this.getLineage().peek().getTid();
                this.extent = new Extent(parentTransactionId);
            }
        }
        return this.extent;
    }

    @Override
    public void setRollbackOnly() {
        this.localGetTransactionStateHandler().setRollbackOnly();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("setRollbackOnly() called for transaction " + this.getTid());
        }
    }

    @Override
    public void commit() throws HeurMixedException, HeurHazardException, SysException, SecurityException, RollbackException {
        this.doCommit();
        this.setSiblingInfoForIncoming1pcRequestFromRemoteClient();
        try {
            if (this.isRoot()) {
                this.coordinator.terminate(true);
            } else {
                this.coordinator.incLocalSiblingsTerminated();
            }
        }
        catch (HeurRollbackException rb) {
            throw new RollbackException("Transaction was rolled back", (Throwable)rb);
        }
        catch (RollbackException rb) {
            throw rb;
        }
        catch (HeurHazardException | HeurMixedException h) {
            if (this.throwOnHeuristic()) {
                throw h;
            }
        }
        catch (SysException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SysException("Unexpected error: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean throwOnHeuristic() {
        return Configuration.getConfigProperties().getThrowOnHeuristic();
    }

    private void setSiblingInfoForIncoming1pcRequestFromRemoteClient() {
        Map cascadelist = this.getExtent().getRemoteParticipants();
        this.coordinator.setGlobalSiblingCount(this.coordinator.getLocalSiblingCount());
        this.coordinator.setCascadeList(cascadelist);
    }

    @Override
    public void rollback() throws IllegalStateException, SysException {
        this.doRollback();
        try {
            if (this.isRoot()) {
                this.coordinator.terminate(false);
            } else {
                this.coordinator.incLocalSiblingsTerminated();
            }
        }
        catch (Exception e) {
            throw new SysException("Unexpected error in rollback: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public TxState getState() {
        return this.localGetTransactionStateHandler().getState();
    }

    @Override
    public void entered(FSMEnterEvent coordinatorTerminatedEvent) {
        if (this.getState().isOneOf(new TxState[]{TxState.ACTIVE, TxState.MARKED_ABORT})) {
            try {
                if (!(this.stateHandler instanceof TxTerminatedStateHandler)) {
                    this.setRollbackOnly();
                } else {
                    this.rollback();
                }
            }
            catch (Exception e) {
                LOGGER.logTrace("Ignoring error during event callback", (Throwable)e);
            }
        }
    }
}

