/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.recovery.fs;

import com.atomikos.icatch.config.Configuration;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.LogException;
import com.atomikos.recovery.LogReadException;
import com.atomikos.recovery.PendingTransactionRecord;
import com.atomikos.recovery.RecoveryLog;
import com.atomikos.recovery.TxState;
import com.atomikos.recovery.fs.Repository;
import com.atomikos.thread.InterruptedExceptionHelper;
import java.util.Collection;
import java.util.HashSet;

public class RecoveryLogImp
implements RecoveryLog {
    private static final Logger LOGGER = LoggerFactory.createLogger(RecoveryLogImp.class);
    private Repository repository;
    private String recoveryDomainName = Configuration.getConfigProperties().getTmUniqueName();

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public PendingTransactionRecord[] getPendingTransactionRecords() {
        try {
            Collection<PendingTransactionRecord> allCoordinatorLogEntries = this.repository.getAllCoordinatorLogEntries();
            return allCoordinatorLogEntries.toArray(new PendingTransactionRecord[allCoordinatorLogEntries.size()]);
        }
        catch (LogReadException e) {
            LOGGER.logError("Could not retrieve coordinators - returning empty array", (Throwable)e);
            return new PendingTransactionRecord[0];
        }
    }

    public void close(long maxWaitTime) {
        PendingTransactionRecord[] pendingCoordinatorLogEntries;
        if (maxWaitTime > 0L) {
            this.waitForActiveTransactionsToFinish(maxWaitTime);
        }
        if ((pendingCoordinatorLogEntries = this.getPendingTransactionRecords()).length > 0) {
            LOGGER.logWarning("Shutdown leaves pending transactions in log - do NOT delete logfiles!");
        } else {
            LOGGER.logInfo("Shutdown leaves no pending transactions - ok to delete logfiles");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void waitForActiveTransactionsToFinish(long maxWaitTime) {
        PendingTransactionRecord[] pendingCoordinatorLogEntries = this.getPendingTransactionRecords();
        int waitTime = 1000;
        for (long accumulatedWaitTime = 0L; pendingCoordinatorLogEntries.length > 0 && accumulatedWaitTime < maxWaitTime; accumulatedWaitTime += (long)waitTime) {
            LOGGER.logInfo("Waiting for termination of pending coordinators...");
            RecoveryLogImp recoveryLogImp = this;
            synchronized (recoveryLogImp) {
                block6: {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException ex) {
                        InterruptedExceptionHelper.handleInterruptedException((InterruptedException)ex);
                        if (!LOGGER.isTraceEnabled()) break block6;
                        LOGGER.logTrace(this + ": interrupted during wait", (Throwable)ex);
                    }
                }
            }
            pendingCoordinatorLogEntries = this.getPendingTransactionRecords();
        }
    }

    public void forgetCommittingCoordinatorsExpiredSince(long expiry) {
        HashSet<PendingTransactionRecord> expiredCommittingCoordinators = new HashSet<PendingTransactionRecord>();
        try {
            expiredCommittingCoordinators.addAll(this.getExpiredPendingCommittingTransactionRecordsAt(expiry));
        }
        catch (Exception e) {
            LOGGER.logWarning("Unexpected error while retrieving coordinators", (Throwable)e);
        }
        for (PendingTransactionRecord coordinatorLogEntry : expiredCommittingCoordinators) {
            PendingTransactionRecord terminated = coordinatorLogEntry.markAsTerminated();
            try {
                this.repository.put(terminated.id, terminated);
            }
            catch (Exception e) {
                LOGGER.logWarning("Unexpected error while forgetting coordinator: " + terminated.id, (Throwable)e);
            }
        }
    }

    public Collection<PendingTransactionRecord> getExpiredPendingCommittingTransactionRecordsAt(long time) throws LogReadException {
        HashSet<PendingTransactionRecord> expiredCommittingCoordinatorsAt = new HashSet<PendingTransactionRecord>();
        Collection<PendingTransactionRecord> allCoordinatorLogEntries = this.repository.findAllCommittingCoordinatorLogEntries();
        for (PendingTransactionRecord pendingTransactionRecord : allCoordinatorLogEntries) {
            String superiorId = pendingTransactionRecord.superiorId;
            if (superiorId != null) {
                HashSet<PendingTransactionRecord> ret = new HashSet<PendingTransactionRecord>();
                this.collectExpiredCommittingSuperiorCoordinatorsAt(ret, superiorId, time);
                if (!ret.isEmpty()) {
                    ret.add(pendingTransactionRecord);
                }
                expiredCommittingCoordinatorsAt.addAll(ret);
                continue;
            }
            if (pendingTransactionRecord.expires >= time || pendingTransactionRecord.state != TxState.COMMITTING) continue;
            expiredCommittingCoordinatorsAt.add(pendingTransactionRecord);
        }
        return expiredCommittingCoordinatorsAt;
    }

    private void collectExpiredCommittingSuperiorCoordinatorsAt(Collection<PendingTransactionRecord> collector, String superiorId, long time) throws LogReadException {
        PendingTransactionRecord superior = this.repository.get(superiorId);
        if (superior != null) {
            if (superior.superiorId != null) {
                this.collectExpiredCommittingSuperiorCoordinatorsAt(collector, superior.superiorId, time);
            } else if (superior.expires < time && superior.state == TxState.COMMITTING) {
                collector.add(superior);
            }
        }
    }

    public void forgetNativeIndoubtCoordinatorsExpiredSince(long momentInThePast) {
        try {
            Collection<PendingTransactionRecord> allCoordinatorLogEntries = this.repository.getAllCoordinatorLogEntries();
            for (PendingTransactionRecord entry : allCoordinatorLogEntries) {
                if (entry.expires >= momentInThePast || entry.state != TxState.IN_DOUBT || this.isForeign(entry)) continue;
                PendingTransactionRecord terminated = entry.markAsTerminated();
                this.repository.put(terminated.id, terminated);
            }
        }
        catch (Exception e) {
            LOGGER.logDebug("Unexpected exception - ignoring...", (Throwable)e);
        }
    }

    public Collection<PendingTransactionRecord> getForeignIndoubtTransactionRecords() throws LogReadException {
        HashSet<PendingTransactionRecord> ret = new HashSet<PendingTransactionRecord>();
        Collection<PendingTransactionRecord> allCoordinatorLogEntries = this.repository.getAllCoordinatorLogEntries();
        for (PendingTransactionRecord entry : allCoordinatorLogEntries) {
            if (entry.state != TxState.IN_DOUBT || !this.isForeign(entry)) continue;
            ret.add(entry);
        }
        return ret;
    }

    private boolean isForeign(PendingTransactionRecord entry) {
        return !this.recoveryDomainName.equals(entry.recoveryDomainName);
    }

    public boolean isActive() {
        return true;
    }

    public void forgetTransactionRecords(Collection<PendingTransactionRecord> coordinators) {
        try {
            for (PendingTransactionRecord entry : coordinators) {
                PendingTransactionRecord terminated = entry.markAsTerminated();
                this.repository.put(terminated.id, terminated);
            }
        }
        catch (Exception e) {
            LOGGER.logDebug("Unexpected exception - ignoring...", (Throwable)e);
        }
    }

    public void recordAsCommitting(String coordinatorId) throws LogException {
        PendingTransactionRecord entry = this.repository.get(coordinatorId);
        PendingTransactionRecord committing = entry.markAsCommitting();
        this.repository.put(committing.id, committing);
    }

    public void forget(String coordinatorId) throws LogException {
        PendingTransactionRecord rec = this.repository.get(coordinatorId);
        PendingTransactionRecord terminated = rec.markAsTerminated();
        this.repository.put(terminated.id, terminated);
    }

    public PendingTransactionRecord get(String coordinatorId) throws LogReadException {
        return this.repository.get(coordinatorId);
    }
}

