/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.event.Event;
import com.atomikos.icatch.event.transaction.TransactionHeuristicEvent;
import com.atomikos.icatch.imp.ResourceLookup;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.publish.EventPublisher;
import com.atomikos.recovery.PendingTransactionRecord;
import com.atomikos.recovery.RecoveryLog;
import com.atomikos.recovery.TxState;
import com.atomikos.thread.TaskManager;
import com.atomikos.timing.AlarmTimer;
import com.atomikos.timing.AlarmTimerListener;
import com.atomikos.timing.PooledAlarmTimer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RecoveryDomainService {
    private static final Logger LOGGER = LoggerFactory.createLogger(RecoveryDomainService.class);
    private RecoveryLog recoveryLog;
    private ResourceLookup lookup;
    private long maxTimeout;
    private PooledAlarmTimer recoveryTimer;

    public RecoveryDomainService(RecoveryLog recoveryLog) {
        this.recoveryLog = recoveryLog;
    }

    public RecoveryDomainService(RecoveryLog recoveryLog, ResourceLookup lookup) {
        this(recoveryLog);
        this.lookup = lookup;
    }

    public void init() {
        long recoveryDelay = Configuration.getConfigProperties().getRecoveryDelay();
        this.setMaxTimeout(Configuration.getConfigProperties().getMaxTimeout());
        this.recoveryTimer = new PooledAlarmTimer(recoveryDelay);
        this.recoveryTimer.addAlarmTimerListener(new AlarmTimerListener(){

            public void alarm(AlarmTimer timer) {
                RecoveryDomainService.this.performRecovery();
            }
        });
        TaskManager.SINGLETON.executeTask((Runnable)this.recoveryTimer);
    }

    public void setMaxTimeout(long maxTimeout) {
        this.maxTimeout = maxTimeout;
    }

    protected void performRecovery() {
        if (this.recoveryLog.isActive()) {
            try {
                boolean allOk = true;
                long startOfRecovery = System.currentTimeMillis();
                Set<RecoverableResource> resourcesToRecover = this.getResourcesForRecovery();
                Collection foreignIndoubtCoordinators = this.recoveryLog.getForeignIndoubtTransactionRecords();
                Collection expiredCommittingCoordinators = this.recoveryLog.getExpiredPendingCommittingTransactionRecordsAt(startOfRecovery);
                Collection<PendingTransactionRecord> foreignCoordinatorsForHeuristicAbort = this.extractForeignIndoubtCoordinatorsForHeuristicAbort(foreignIndoubtCoordinators, startOfRecovery);
                for (RecoverableResource recoverableResource : resourcesToRecover) {
                    try {
                        allOk = allOk && recoverableResource.recover(startOfRecovery, expiredCommittingCoordinators, foreignIndoubtCoordinators);
                    }
                    catch (Throwable e) {
                        allOk = false;
                        LOGGER.logError(e.getMessage(), e);
                    }
                }
                if (allOk) {
                    this.recoveryLog.forgetCommittingCoordinatorsExpiredSince(startOfRecovery);
                    this.recoveryLog.forgetNativeIndoubtCoordinatorsExpiredSince(startOfRecovery - this.maxTimeout);
                }
                this.recoveryLog.forgetTransactionRecords(foreignCoordinatorsForHeuristicAbort);
                Collection<PendingTransactionRecord> resolvedForeignCoordinators = this.extractResolvedForeignCoordinators(foreignIndoubtCoordinators);
                this.recoveryLog.forgetTransactionRecords(resolvedForeignCoordinators);
            }
            catch (Throwable e) {
                LOGGER.logError(e.getMessage(), e);
            }
        }
    }

    private Collection<PendingTransactionRecord> extractResolvedForeignCoordinators(Collection<PendingTransactionRecord> foreignIndoubtCoordinators) {
        HashSet<PendingTransactionRecord> ret = new HashSet<PendingTransactionRecord>();
        for (PendingTransactionRecord rec : foreignIndoubtCoordinators) {
            if (TxState.IN_DOUBT.equals((Object)rec.state)) continue;
            ret.add(rec);
        }
        return ret;
    }

    private Collection<PendingTransactionRecord> extractForeignIndoubtCoordinatorsForHeuristicAbort(Collection<PendingTransactionRecord> foreignIndoubtCoordinators, long startOfRecovery) {
        HashSet<PendingTransactionRecord> ret = new HashSet<PendingTransactionRecord>();
        Iterator<PendingTransactionRecord> it = foreignIndoubtCoordinators.iterator();
        while (it.hasNext()) {
            TransactionHeuristicEvent event;
            PendingTransactionRecord record = it.next();
            if (record.expires + this.maxTimeout >= startOfRecovery) continue;
            String recoveryCoordinatorURI = record.superiorId;
            if (!recoveryCoordinatorURI.startsWith("http")) {
                ret.add(record);
                it.remove();
                event = new TransactionHeuristicEvent(record.id, record.superiorId, TxState.HEUR_ABORTED);
                EventPublisher.publish((Event)event);
                continue;
            }
            event = new TransactionHeuristicEvent(record.id, record.superiorId, TxState.IN_DOUBT);
            EventPublisher.publish((Event)event);
        }
        return ret;
    }

    private Set<RecoverableResource> getResourcesForRecovery() {
        Collection<RecoverableResource> resources = null;
        resources = this.lookup == null ? Configuration.getResources() : this.lookup.getResources();
        return this.filterDuplicates(resources);
    }

    private Set<RecoverableResource> filterDuplicates(Collection<RecoverableResource> resources) {
        return new HashSet<RecoverableResource>(resources);
    }

    public void stop() {
        if (this.recoveryTimer != null) {
            this.recoveryTimer.stop();
            this.recoveryTimer = null;
        }
    }
}

