/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.recovery.imp;

import com.atomikos.icatch.event.Event;
import com.atomikos.icatch.event.transaction.TransactionHeuristicEvent;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.publish.EventPublisher;
import com.atomikos.recovery.AdminLog;
import com.atomikos.recovery.CoordinatorLogEntry;
import com.atomikos.recovery.LogException;
import com.atomikos.recovery.LogReadException;
import com.atomikos.recovery.LogWriteException;
import com.atomikos.recovery.ParticipantLogEntry;
import com.atomikos.recovery.RecoveryLog;
import com.atomikos.recovery.Repository;
import com.atomikos.recovery.TxState;
import com.atomikos.thread.InterruptedExceptionHelper;
import java.util.Collection;
import java.util.HashSet;

public class RecoveryLogImp
implements RecoveryLog,
AdminLog {
    private static final Logger LOGGER = LoggerFactory.createLogger(RecoveryLogImp.class);
    private Repository repository;

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void terminated(ParticipantLogEntry entry) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace("terminated: " + entry);
        }
        try {
            CoordinatorLogEntry coordinatorLogEntry = null;
            coordinatorLogEntry = this.repository.get(entry.coordinatorId);
            if (coordinatorLogEntry == null) {
                LOGGER.logWarning("termination called on non existent Coordinator " + entry.coordinatorId + " " + entry.uri);
            } else {
                CoordinatorLogEntry updated = coordinatorLogEntry.terminated(entry);
                this.repository.put(updated.id, updated);
                if (coordinatorLogEntry.superiorCoordinatorId != null) {
                    this.terminateParentTx(coordinatorLogEntry);
                }
            }
        }
        catch (LogException e) {
            LOGGER.logError("Unable to write to repository: " + entry + " - leaving cleanup to recovery housekeeping...", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.logError("Unexpected error while terminating participant entry - ignoring (may result in orphaned log entry)", (Throwable)e);
        }
    }

    protected void terminateParentTx(CoordinatorLogEntry coordinatorLogEntry) throws LogReadException, LogWriteException {
        CoordinatorLogEntry parentCoordinatorLogEntry = this.repository.get(coordinatorLogEntry.superiorCoordinatorId);
        if (parentCoordinatorLogEntry != null) {
            CoordinatorLogEntry parentUpdated = parentCoordinatorLogEntry.terminated(this.createSubTransactionCoordinatorParticipant(coordinatorLogEntry));
            this.repository.put(parentUpdated.id, parentUpdated);
        }
    }

    protected ParticipantLogEntry createSubTransactionCoordinatorParticipant(CoordinatorLogEntry subTransaction) {
        return new ParticipantLogEntry(subTransaction.superiorCoordinatorId, subTransaction.id, subTransaction.expires(), "subtransaction participant", subTransaction.getResultingState());
    }

    public void terminatedWithHeuristicRollback(ParticipantLogEntry entry) throws LogException {
        LOGGER.logDebug("terminatedWithHeuristicRollback: " + entry);
        CoordinatorLogEntry coordinatorLogEntry = this.repository.get(entry.coordinatorId);
        if (coordinatorLogEntry == null) {
            LOGGER.logWarning("terminatedWithHeuristicRollback called on non existent Coordinator " + entry.coordinatorId + " " + entry.uri);
        } else {
            CoordinatorLogEntry updated = coordinatorLogEntry.terminatedWithHeuristicRollback(entry);
            this.repository.put(updated.id, updated);
            if (coordinatorLogEntry.superiorCoordinatorId != null) {
                ParticipantLogEntry subTransaction = this.createSubTransactionCoordinatorParticipant(coordinatorLogEntry);
                this.terminatedWithHeuristicRollback(subTransaction);
            }
            this.publishDomainEvent(new TransactionHeuristicEvent(entry.coordinatorId));
        }
    }

    private void publishDomainEvent(TransactionHeuristicEvent transactionHeuristicEvent) {
        EventPublisher.publish((Event)transactionHeuristicEvent);
    }

    public Collection<ParticipantLogEntry> getCommittingParticipants() throws LogReadException {
        HashSet<ParticipantLogEntry> committingParticipants = new HashSet<ParticipantLogEntry>();
        Collection committingCoordinatorLogEntries = this.repository.findAllCommittingCoordinatorLogEntries();
        for (CoordinatorLogEntry coordinatorLogEntry : committingCoordinatorLogEntries) {
            for (ParticipantLogEntry participantLogEntry : coordinatorLogEntry.participants) {
                committingParticipants.add(participantLogEntry);
            }
        }
        return committingParticipants;
    }

    private void write(CoordinatorLogEntry coordinatorLogEntry) throws IllegalStateException, LogException {
        if (!this.entryAllowed(coordinatorLogEntry)) {
            throw new IllegalStateException();
        }
        this.repository.put(coordinatorLogEntry.id, coordinatorLogEntry);
    }

    private boolean entryAllowed(CoordinatorLogEntry coordinatorLogEntry) throws LogReadException {
        CoordinatorLogEntry existing = this.repository.get(coordinatorLogEntry.id);
        return coordinatorLogEntry.transitionAllowedFrom(existing);
    }

    public void presumedAborting(ParticipantLogEntry entry) throws IllegalStateException, LogException {
        CoordinatorLogEntry parentCoordinatorLogEntry;
        if (entry == null || entry.state != TxState.IN_DOUBT) {
            throw new IllegalArgumentException();
        }
        CoordinatorLogEntry coordinatorLogEntry = this.repository.get(entry.coordinatorId);
        if (coordinatorLogEntry == null) {
            coordinatorLogEntry = this.createCoordinatorLogEntry(entry);
            this.write(coordinatorLogEntry);
            throw new IllegalStateException();
        }
        if (coordinatorLogEntry.superiorCoordinatorId != null && (parentCoordinatorLogEntry = this.repository.get(coordinatorLogEntry.superiorCoordinatorId)) != null && parentCoordinatorLogEntry.getResultingState() == TxState.IN_DOUBT) {
            ParticipantLogEntry subTransaction = this.createSubTransactionCoordinatorParticipant(coordinatorLogEntry);
            this.presumedAborting(subTransaction);
        }
        CoordinatorLogEntry updated = coordinatorLogEntry.presumedAborting(entry);
        this.write(updated);
    }

    private CoordinatorLogEntry createCoordinatorLogEntry(ParticipantLogEntry entry) {
        ParticipantLogEntry[] participantDetails = new ParticipantLogEntry[]{entry};
        CoordinatorLogEntry coordinatorLogEntry = new CoordinatorLogEntry(entry.coordinatorId, participantDetails);
        return coordinatorLogEntry;
    }

    public void terminatedWithHeuristicCommit(ParticipantLogEntry entry) throws LogException {
        LOGGER.logDebug("terminatedWithHeuristicCommit: " + entry);
        CoordinatorLogEntry coordinatorLogEntry = this.repository.get(entry.coordinatorId);
        if (coordinatorLogEntry == null) {
            LOGGER.logWarning("terminatedWithHeuristicCommit called on non existent Coordinator " + entry.coordinatorId + " " + entry.uri);
        } else {
            CoordinatorLogEntry updated = coordinatorLogEntry.terminatedWithHeuristicCommit(entry);
            this.repository.put(updated.id, updated);
            if (coordinatorLogEntry.superiorCoordinatorId != null) {
                ParticipantLogEntry subTransaction = this.createSubTransactionCoordinatorParticipant(coordinatorLogEntry);
                this.terminatedWithHeuristicCommit(subTransaction);
            }
            this.publishDomainEvent(new TransactionHeuristicEvent(entry.coordinatorId));
        }
    }

    public void terminatedWithHeuristicHazard(ParticipantLogEntry entry) {
        LOGGER.logDebug("terminatedWithHeuristicHazard " + entry);
        this.publishDomainEvent(new TransactionHeuristicEvent(entry.coordinatorId));
    }

    public void terminatedWithHeuristicMixed(ParticipantLogEntry entry) throws LogException {
        LOGGER.logDebug("terminatedWithHeuristicMixed " + entry);
        CoordinatorLogEntry coordinatorLogEntry = this.repository.get(entry.coordinatorId);
        if (coordinatorLogEntry == null) {
            LOGGER.logWarning("terminatedWithHeuristicMixed called on non existent Coordinator " + entry.coordinatorId + " " + entry.uri);
        } else {
            CoordinatorLogEntry updated = coordinatorLogEntry.terminatedWithHeuristicMixed(entry);
            this.repository.put(updated.id, updated);
            if (coordinatorLogEntry.superiorCoordinatorId != null) {
                ParticipantLogEntry subTransaction = this.createSubTransactionCoordinatorParticipant(coordinatorLogEntry);
                this.terminatedWithHeuristicMixed(subTransaction);
            }
            this.publishDomainEvent(new TransactionHeuristicEvent(entry.coordinatorId));
        }
    }

    public CoordinatorLogEntry[] getCoordinatorLogEntries() {
        try {
            Collection allCoordinatorLogEntries = this.repository.getAllCoordinatorLogEntries();
            return allCoordinatorLogEntries.toArray(new CoordinatorLogEntry[allCoordinatorLogEntries.size()]);
        }
        catch (LogReadException e) {
            LOGGER.logError("Could not retrieve coordinators - returning empty array", (Throwable)e);
            return new CoordinatorLogEntry[0];
        }
    }

    public void remove(String coordinatorId) {
        CoordinatorLogEntry toRemove = null;
        try {
            toRemove = this.repository.get(coordinatorId);
        }
        catch (LogReadException e) {
            LOGGER.logWarning("Could not retrieve coordinator to remove: " + coordinatorId + " - ignoring", (Throwable)e);
        }
        if (toRemove != null) {
            toRemove = toRemove.markAsTerminated();
            try {
                this.repository.put(coordinatorId, toRemove);
            }
            catch (Exception e) {
                LOGGER.logWarning("Could not remove coordinator: " + coordinatorId + " - ignoring", (Throwable)e);
            }
        }
    }

    public void close(long maxWaitTime) {
        CoordinatorLogEntry[] pendingCoordinatorLogEntries;
        if (maxWaitTime > 0L) {
            this.waitForActiveTransactionsToFinish(maxWaitTime);
        }
        if ((pendingCoordinatorLogEntries = this.getCoordinatorLogEntries()).length > 0) {
            LOGGER.logWarning("Shutdown leaves pending transactions in log - do NOT delete logfiles!");
        } else {
            LOGGER.logInfo("Shutdown leaves no pending transactions - ok to delete logfiles");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void waitForActiveTransactionsToFinish(long maxWaitTime) {
        CoordinatorLogEntry[] pendingCoordinatorLogEntries = this.getCoordinatorLogEntries();
        int waitTime = 1000;
        for (long accumulatedWaitTime = 0L; pendingCoordinatorLogEntries.length > 0 && accumulatedWaitTime < maxWaitTime; accumulatedWaitTime += (long)waitTime) {
            LOGGER.logInfo("Waiting for termination of pending coordinators...");
            RecoveryLogImp recoveryLogImp = this;
            synchronized (recoveryLogImp) {
                block6: {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException ex) {
                        InterruptedExceptionHelper.handleInterruptedException((InterruptedException)ex);
                        if (!LOGGER.isTraceEnabled()) break block6;
                        LOGGER.logTrace(this + ": interrupted during wait", (Throwable)ex);
                    }
                }
            }
            pendingCoordinatorLogEntries = this.getCoordinatorLogEntries();
        }
    }
}

