/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.imp;

import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMPreEnterListener;
import com.atomikos.persistence.LogException;
import com.atomikos.persistence.ObjectImage;
import com.atomikos.persistence.Recoverable;
import com.atomikos.persistence.StateRecoverable;
import com.atomikos.persistence.StateRecoveryManager;
import com.atomikos.persistence.imp.StateObjectImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class VolatileStateRecoveryManager
implements StateRecoveryManager,
FSMPreEnterListener {
    private Map idToElementMap = new HashMap();

    public void init() throws LogException {
    }

    public void register(StateRecoverable stateRecoverable) {
        if (stateRecoverable == null) {
            throw new IllegalArgumentException("null in register arg");
        }
        Object[] objectArray = stateRecoverable.getRecoverableStates();
        if (objectArray != null) {
            int n;
            for (n = 0; n < objectArray.length; ++n) {
                stateRecoverable.addFSMPreEnterListener(this, objectArray[n]);
            }
            objectArray = stateRecoverable.getFinalStates();
            for (n = 0; n < objectArray.length; ++n) {
                stateRecoverable.addFSMPreEnterListener(this, objectArray[n]);
            }
        }
    }

    public synchronized void preEnter(FSMEnterEvent fSMEnterEvent) throws IllegalStateException {
        Object object = fSMEnterEvent.getState();
        StateRecoverable stateRecoverable = (StateRecoverable)fSMEnterEvent.getSource();
        ObjectImage objectImage = stateRecoverable.getObjectImage(object);
        if (objectImage != null) {
            StateObjectImage stateObjectImage = new StateObjectImage(objectImage);
            Object[] objectArray = stateRecoverable.getFinalStates();
            boolean bl = false;
            for (int i = 0; i < objectArray.length; ++i) {
                if (!object.equals(objectArray[i])) continue;
                bl = true;
            }
            if (!bl) {
                this.idToElementMap.put(stateObjectImage.getId(), stateObjectImage);
            } else {
                this.idToElementMap.remove(stateObjectImage.getId());
            }
        }
    }

    public void close() throws LogException {
    }

    public StateRecoverable recover(Object object) throws LogException {
        StateRecoverable stateRecoverable = null;
        StateObjectImage stateObjectImage = (StateObjectImage)this.idToElementMap.get(object);
        stateRecoverable = (StateRecoverable)stateObjectImage.restore();
        return stateRecoverable;
    }

    public Vector recover() throws LogException {
        Vector<Recoverable> vector = new Vector<Recoverable>();
        Iterator iterator = this.idToElementMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            StateObjectImage stateObjectImage = (StateObjectImage)this.idToElementMap.get(k);
            vector.add(stateObjectImage.restore());
        }
        return vector;
    }

    public synchronized void delete(Object object) throws LogException {
        this.idToElementMap.remove(object);
    }
}

