/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.system;

public class Waiter {
    private int numActive = 0;
    private int abortCount = 0;
    private boolean noneActive = true;

    synchronized int getNumActive() {
        return this.numActive;
    }

    synchronized void getToken() throws InterruptedException {
        while (!this.noneActive) {
            this.wait();
        }
        this.noneActive = false;
    }

    synchronized void giveToken() {
        this.noneActive = true;
        this.notifyAll();
    }

    synchronized void incActives() {
        ++this.numActive;
    }

    public synchronized void waitForAll() {
        try {
            while (this.numActive > 0) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized void incAbortCount() {
        ++this.abortCount;
    }

    synchronized void decActives() {
        --this.numActive;
        if (this.numActive == 0) {
            this.notifyAll();
        }
    }

    public int getAbortCount() {
        return this.abortCount;
    }
}

