/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp.thread;

import com.atomikos.icatch.imp.thread.ExecutorFactory;
import com.atomikos.icatch.imp.thread.InternalSystemExecutor;
import com.atomikos.icatch.imp.thread.Java14BackportExecutorFactory;
import com.atomikos.icatch.imp.thread.Java15ExecutorFactory;
import com.atomikos.icatch.imp.thread.TrivialExecutorFactory;
import com.atomikos.icatch.imp.thread.TrivialSystemExecutor;
import com.atomikos.icatch.system.Configuration;

public class TaskManager {
    private static TaskManager singleton;
    private InternalSystemExecutor executor;

    public static final synchronized TaskManager getInstance() {
        if (singleton == null) {
            Configuration.logDebug("TaskManager: initializing...");
            singleton = new TaskManager();
        }
        return singleton;
    }

    protected TaskManager() {
        this.init();
    }

    private void init() {
        ExecutorFactory executorFactory;
        try {
            if (this.isClassAvailable("java.util.concurrent.ThreadPoolExecutor")) {
                Configuration.logInfo("THREADS: using JDK thread pooling...");
                executorFactory = new Java15ExecutorFactory();
            } else if (this.isClassAvailable("edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor")) {
                Configuration.logInfo("THREADS: using 1.4 (backport) thread pooling...");
                executorFactory = new Java14BackportExecutorFactory();
            } else {
                Configuration.logWarning("THREADS: pooling NOT enabled!");
                executorFactory = new TrivialExecutorFactory();
            }
        }
        catch (Exception exception) {
            Configuration.logWarning("THREADS: Illegal setup, thread pooling is NOT enabled!", exception);
            executorFactory = new TrivialExecutorFactory();
        }
        try {
            this.executor = executorFactory.createExecutor();
        }
        catch (Exception exception) {
            Configuration.logWarning("Failed to create system executor; Received message: " + exception.getMessage() + "; Failling back to a trivial executor.", exception);
            this.executor = new TrivialSystemExecutor();
        }
        Configuration.logDebug("THREADS: using executor " + this.executor.getClass());
    }

    public synchronized void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    public void executeTask(Runnable runnable) {
        if (this.executor == null) {
            this.init();
        }
        this.executor.execute(runnable);
    }

    private boolean isClassAvailable(String string) {
        try {
            Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

