/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.CompositeTransactionImp;
import com.atomikos.icatch.imp.TransactionStateHandler;
import java.util.Stack;

class TxTerminatingStateHandler
extends TransactionStateHandler {
    private boolean committing;

    public TxTerminatingStateHandler(boolean bl, CompositeTransactionImp compositeTransactionImp, TransactionStateHandler transactionStateHandler) {
        super(compositeTransactionImp, transactionStateHandler);
        this.committing = bl;
    }

    private void reject() throws IllegalStateException {
        if (this.committing) {
            throw new IllegalStateException("Transaction is committing - adding a new participant is not allowed");
        }
        throw new IllegalStateException("Transaction is rolling back - adding a new participant is not allowed");
    }

    protected Object getState() {
        return TxState.ACTIVE;
    }

    protected RecoveryCoordinator addParticipant(Participant participant) {
        if (!this.committing) {
            this.reject();
        }
        return super.addParticipant(participant);
    }

    protected void addSubTxAwareParticipant(SubTxAwareParticipant subTxAwareParticipant) {
        if (!this.committing) {
            this.reject();
        }
        super.addSubTxAwareParticipant(subTxAwareParticipant);
    }

    protected void addSynchronizations(Stack stack) {
        this.reject();
    }

    protected void commit() {
        this.reject();
    }

    protected CompositeTransaction createSubTransaction() {
        this.reject();
        return null;
    }

    protected void registerSynchronization() {
        this.reject();
    }

    protected void rollbackWithStateCheck() {
        if (this.committing) {
            this.reject();
        }
    }

    protected void setRollbackOnly() {
        if (this.committing) {
            super.setRollbackOnly();
        }
    }
}

